"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRootStreamDefinition = void 0;
var _streams = require("../models/streams");
var _type_guards = require("../shared/type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isRootStreamDefinition = exports.isRootStreamDefinition = (0, _type_guards.createIsNarrowSchema)(_streams.Streams.all.Definition.right, _streams.Streams.WiredStream.Definition.right.refine(stream => {
  return stream.name.split('.').length === 1;
}));