"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAdvancedParameters = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Parameters that we consider first class and provide a curated experience for, or are added as metadata.
const FIRST_CLASS_PARAMETERS = ['type', 'format', 'from'];

// Advanced parameters that we provide a generic experience (JSON blob) for
const getAdvancedParameters = (fieldName, fieldConfig) => {
  // @timestamp can't ignore malformed dates as it's used for sorting in logsdb
  const additionalOmissions = fieldName === '@timestamp' ? ['ignore_malformed'] : [];
  return (0, _lodash.omit)(fieldConfig, FIRST_CLASS_PARAMETERS.concat(additionalOmissions));
};
exports.getAdvancedParameters = getAdvancedParameters;