"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _fake_request_factory = require("../../helpers/fake_request_factory");
var _query_client = require("./query_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class QueryService {
  constructor(coreSetup, logger) {
    this.coreSetup = coreSetup;
    this.logger = logger;
  }
  async getClientWithRequest({
    request,
    assetClient
  }) {
    var _await$uiSettings$get;
    const [core, pluginStart] = await this.coreSetup.getStartServices();
    const soClient = core.savedObjects.getScopedClient(request);
    const uiSettings = core.uiSettings.asScopedToClient(soClient);
    const isSignificantEventsEnabled = (_await$uiSettings$get = await uiSettings.get(_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS)) !== null && _await$uiSettings$get !== void 0 ? _await$uiSettings$get : false;
    const fakeRequest = (0, _fake_request_factory.createFakeRequestBoundToDefaultSpace)(request);
    const rulesClient = await pluginStart.alerting.getRulesClientWithRequest(fakeRequest);
    return new _query_client.QueryClient({
      assetClient,
      rulesClient,
      logger: this.logger
    }, isSignificantEventsEnabled);
  }
}
exports.QueryService = QueryService;