"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamFeaturesApi = useStreamFeaturesApi;
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStreamFeaturesApi(definition) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal,
    abort,
    refresh
  } = (0, _reactHooks.useAbortController)();
  return {
    identifyFeatures: async (connectorId, to, from) => {
      return await streamsRepositoryClient.fetch('POST /internal/streams/{name}/features/_identify', {
        signal,
        params: {
          path: {
            name: definition.name
          },
          query: {
            connectorId,
            to,
            from
          }
        }
      });
    },
    addFeaturesToStream: async features => {
      return await streamsRepositoryClient.fetch('POST /internal/streams/{name}/features/_bulk', {
        signal,
        params: {
          path: {
            name: definition.name
          },
          body: {
            operations: features.map(feature => ({
              index: {
                feature
              }
            }))
          }
        }
      });
    },
    removeFeaturesFromStream: async featureNames => {
      return await streamsRepositoryClient.fetch('POST /internal/streams/{name}/features/_bulk', {
        signal,
        params: {
          path: {
            name: definition.name
          },
          body: {
            operations: featureNames.map(feature => ({
              delete: {
                feature: {
                  name: feature
                }
              }
            }))
          }
        }
      });
    },
    upsertQuery: async (featureName, request) => {
      await streamsRepositoryClient.fetch('PUT /internal/streams/{name}/features/{featureName}', {
        signal,
        params: {
          path: {
            name: definition.name,
            featureName
          },
          body: request
        }
      });
    },
    abort: () => {
      abort();
      refresh();
    }
  };
}