"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverFlyoutStreamProcessingLink = DiscoverFlyoutStreamProcessingLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react2 = require("@emotion/react");
var _use_resolved_definition_name = require("./use_resolved_definition_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/discover_features/discover_flyout_stream_processing_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DiscoverFlyoutStreamProcessingLink({
  streamsRepositoryClient,
  doc,
  locator,
  coreApplication
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value,
    loading,
    error
  } = (0, _use_resolved_definition_name.useResolvedDefinitionName)({
    streamsRepositoryClient,
    doc
  });
  if (loading) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 23
    }
  });
  if (!value || error) return null;
  const hasDocumentId = !!doc.raw._id;
  const href = locator.getRedirectUrl({
    name: value,
    managementTab: 'processing',
    pageState: hasDocumentId ? {
      v: 1,
      dataSources: [{
        type: 'kql-samples',
        enabled: true,
        name: _i18n.i18n.translate('xpack.streams.discoverFlyoutStreamProcessingLink', {
          defaultMessage: 'Discover document'
        }),
        query: {
          language: 'kuery',
          query: `_id: ${doc.raw._id}`
        }
      }]
    } : undefined
  });
  const message = hasDocumentId ? _i18n.i18n.translate('xpack.streams.discoverFlyoutStreamProcessingLink', {
    defaultMessage: 'Parse content in Streams'
  }) : _i18n.i18n.translate('xpack.streams.discoverFlyoutStreamProcessingLinkEdit', {
    defaultMessage: 'Edit processing in Streams'
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: coreApplication
    },
    css: (0, _react2.css)`
        min-width: 0;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: message,
    display: "block",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sparkles",
    size: "s",
    css: (0, _react2.css)`
                margin-left: ${euiTheme.size.s};
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "eui-textTruncate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, message)))));
}