"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSigEventFlyoutTitle = getSigEventFlyoutTitle;
exports.getSigEventSubmitTitle = getSigEventSubmitTitle;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSigEventFlyoutTitle(query) {
  if (!query) {
    return _i18n.i18n.translate('xpack.streams.significantEventFlyout.addNewQueryFlyoutTitle', {
      defaultMessage: 'Add significant event'
    });
  }
  return _i18n.i18n.translate('xpack.streams.significantEventFlyout.editQueryFlyoutTitle', {
    defaultMessage: 'Edit {title}',
    values: {
      title: query.title
    }
  });
}
function getSigEventSubmitTitle(query) {
  if (!query) {
    return _i18n.i18n.translate('xpack.streams.significantEventFlyout.addButtonLabel', {
      defaultMessage: 'Add'
    });
  }
  return _i18n.i18n.translate('xpack.streams.significantEventFlyout.editButtonLabel', {
    defaultMessage: 'Save changes'
  });
}