"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratedFlowForm = GeneratedFlowForm;
var _react = _interopRequireWildcard(require("react"));
var _significant_events_generated_table = require("./significant_events_generated_table");
var _empty_state = require("./empty_state");
var _waiting_for_generation = require("./waiting_for_generation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/generated_flow_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GeneratedFlowForm({
  isGenerating,
  generatedQueries,
  onEditQuery,
  stopGeneration,
  setQueries,
  definition,
  setCanSave,
  isSubmitting,
  features,
  dataViews
}) {
  const [selectedQueries, setSelectedQueries] = (0, _react.useState)([]);
  const [isEditingQueries, setIsEditingQueries] = (0, _react.useState)(false);
  const onSelectionChange = selectedItems => {
    setSelectedQueries(selectedItems);
    setQueries(selectedItems);
  };
  (0, _react.useEffect)(() => {
    setCanSave(!isEditingQueries && selectedQueries.length > 0);
  }, [selectedQueries, isEditingQueries, setCanSave]);
  if (!isGenerating && generatedQueries.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.AiFlowEmptyState, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  }
  if (isGenerating && generatedQueries.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_waiting_for_generation.AiFlowWaitingForGeneration, {
      stopGeneration: stopGeneration,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 12
      }
    });
  }
  if (!isGenerating && generatedQueries.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.AiFlowEmptyState, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 12
      }
    });
  }
  if (isGenerating && generatedQueries.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_waiting_for_generation.AiFlowWaitingForGeneration, {
      stopGeneration: stopGeneration,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_significant_events_generated_table.SignificantEventsGeneratedTable, {
    setIsEditingQueries: setIsEditingQueries,
    isSubmitting: isSubmitting,
    generatedQueries: generatedQueries,
    onEditQuery: onEditQuery,
    selectedQueries: selectedQueries,
    onSelectionChange: onSelectionChange,
    definition: definition,
    features: features,
    dataViews: dataViews,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), isGenerating && /*#__PURE__*/_react.default.createElement(_waiting_for_generation.AiFlowWaitingForGeneration, {
    stopGeneration: stopGeneration,
    hasInitialResults: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }));
}