"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamFeatures = void 0;
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStreamFeatures = definition => {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch(`GET /internal/streams/{name}/features`, {
      signal,
      params: {
        path: {
          name: definition.name
        }
      }
    });
  }, [definition.name, streamsRepositoryClient]);
};
exports.useStreamFeatures = useStreamFeatures;