"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailDashboardsView = StreamDetailDashboardsView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/streams-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_dashboards_api = require("../../hooks/use_dashboards_api");
var _use_dashboards_fetch = require("../../hooks/use_dashboards_fetch");
var _use_kibana = require("../../hooks/use_kibana");
var _add_dashboard_flyout = require("./add_dashboard_flyout");
var _dashboard_table = require("./dashboard_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_dashboards_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StreamDetailDashboardsView({
  definition
}) {
  var _dashboardsFetch$valu3;
  const [query, setQuery] = (0, _react.useState)('');
  const [isAddDashboardFlyoutOpen, setIsAddDashboardFlyoutOpen] = (0, _react.useState)(false);
  const dashboardsFetch = (0, _use_dashboards_fetch.useDashboardsFetch)(definition.stream.name);
  const {
    addDashboards,
    removeDashboards
  } = (0, _use_dashboards_api.useDashboardsApi)(definition.stream.name);
  const [isUnlinkLoading, setIsUnlinkLoading] = (0, _react.useState)(false);
  const linkedDashboards = (0, _react.useMemo)(() => {
    var _dashboardsFetch$valu, _dashboardsFetch$valu2;
    return (_dashboardsFetch$valu = (_dashboardsFetch$valu2 = dashboardsFetch.value) === null || _dashboardsFetch$valu2 === void 0 ? void 0 : _dashboardsFetch$valu2.dashboards) !== null && _dashboardsFetch$valu !== void 0 ? _dashboardsFetch$valu : [];
  }, [(_dashboardsFetch$valu3 = dashboardsFetch.value) === null || _dashboardsFetch$valu3 === void 0 ? void 0 : _dashboardsFetch$valu3.dashboards]);
  const filteredDashboards = (0, _react.useMemo)(() => {
    return linkedDashboards.filter(dashboard => {
      return dashboard.title.toLowerCase().includes(query.toLowerCase());
    });
  }, [linkedDashboards, query]);
  const [selectedDashboards, setSelectedDashboards] = (0, _react.useState)([]);
  const {
    core: {
      application: {
        capabilities: {
          streams: {
            [_public.STREAMS_UI_PRIVILEGES.manage]: canLinkAssets
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, selectedDashboards.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppStreamDetailRemoveDashboardButton",
    iconType: "trash",
    isLoading: isUnlinkLoading,
    onClick: async () => {
      try {
        setIsUnlinkLoading(true);
        await removeDashboards(selectedDashboards);
        dashboardsFetch.refresh();
        setSelectedDashboards([]);
      } finally {
        setIsUnlinkLoading(false);
      }
    },
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.removeSelectedButtonLabel', {
    defaultMessage: 'Unlink selected'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: query,
    box: {
      incremental: true
    },
    onChange: nextQuery => {
      setQuery(nextQuery.queryText);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppStreamDetailAddDashboardButton",
    iconType: "plusInCircle",
    disabled: !canLinkAssets,
    onClick: () => {
      setIsAddDashboardFlyoutOpen(true);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.addADashboardButtonLabel', {
    defaultMessage: 'Add a dashboard'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_table.DashboardsTable, {
    entityId: definition === null || definition === void 0 ? void 0 : definition.stream.name,
    dashboards: filteredDashboards,
    loading: dashboardsFetch.loading,
    selectedDashboards: selectedDashboards,
    setSelectedDashboards: canLinkAssets ? setSelectedDashboards : undefined,
    dataTestSubj: "streamsAppStreamDetailDashboardsTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }), definition && isAddDashboardFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_add_dashboard_flyout.AddDashboardFlyout, {
    linkedDashboards: linkedDashboards,
    entityId: definition.stream.name,
    onAddDashboards: async dashboards => {
      await addDashboards(dashboards);
      dashboardsFetch.refresh();
      setIsAddDashboardFlyoutOpen(false);
    },
    onClose: () => {
      setIsAddDashboardFlyoutOpen(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }) : null));
}