"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassicStreamBadge = ClassicStreamBadge;
exports.DiscoverBadgeButton = DiscoverBadgeButton;
exports.LifecycleBadge = LifecycleBadge;
exports.WiredStreamBadge = WiredStreamBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/discover-plugin/common");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../hooks/use_kibana");
var _icon_stream_classic = _interopRequireDefault(require("../../assets/icon_stream_classic.svg"));
var _icon_stream_wired = _interopRequireDefault(require("../../assets/icon_stream_wired.svg"));
var _truncate_text = require("../../util/truncate_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_badges/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataRetentionTooltip = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  title: _i18n.i18n.translate('xpack.streams.badges.lifecycle.title', {
    defaultMessage: 'Data Retention'
  }),
  content: _i18n.i18n.translate('xpack.streams.badges.lifecycle.description', {
    defaultMessage: 'The data retention period or policy for this stream.'
  }),
  anchorProps: {
    css: (0, _react2.css)`
        display: inline-flex;
      `
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 3
  }
}, children);
function ClassicStreamBadge() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: _i18n.i18n.translate('xpack.streams.badges.classic.title', {
      defaultMessage: 'Classic Stream'
    }),
    content: _i18n.i18n.translate('xpack.streams.badges.classic.description', {
      defaultMessage: "Classic streams are based on existing data streams and don't support all Streams features like partitioning."
    }),
    anchorProps: {
      css: (0, _react2.css)`
          display: inline-flex;
        `
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: _icon_stream_classic.default,
    iconSide: "left",
    tabIndex: 0,
    "data-test-subj": "classicStreamBadge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.unmanagedBadgeLabel', {
    defaultMessage: 'Classic'
  })));
}
function WiredStreamBadge() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: _icon_stream_wired.default,
    iconSide: "left",
    "data-test-subj": "wiredStreamBadge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.managedBadgeLabel', {
    defaultMessage: 'Wired'
  }));
}
function LifecycleBadge({
  lifecycle,
  dataTestSubj
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  let badge;
  if ((0, _streamsSchema.isIlmLifecycle)(lifecycle)) {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "clockCounter",
      iconSide: "left",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": dataTestSubj,
      color: "text",
      target: "_blank",
      href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
        page: 'policy_edit',
        policyName: lifecycle.ilm.policy
      }),
      title: lifecycle.ilm.policy,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.ilmBadgeLabel', {
      defaultMessage: 'ILM Policy: {name}',
      values: {
        name: (0, _truncate_text.truncateText)(lifecycle.ilm.policy, 25)
      }
    })));
  } else if ((0, _streamsSchema.isErrorLifecycle)(lifecycle)) {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.errorBadgeLabel', {
      defaultMessage: 'Error: {message}',
      values: {
        message: lifecycle.error.message
      }
    }));
  } else if ((0, _streamsSchema.isDslLifecycle)(lifecycle)) {
    var _lifecycle$dsl$data_r;
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "clockCounter",
      iconSide: "left",
      tabIndex: 0,
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, (_lifecycle$dsl$data_r = lifecycle.dsl.data_retention) !== null && _lifecycle$dsl$data_r !== void 0 ? _lifecycle$dsl$data_r : _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.dslIndefiniteBadgeLabel', {
      defaultMessage: 'Indefinite'
    }));
  } else {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.disabledLifecycleBadgeLabel', {
      defaultMessage: 'Retention: Disabled'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(DataRetentionTooltip, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 10
    }
  }, badge);
}
function DiscoverBadgeButton({
  definition
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const dataStreamExists = _streamsSchema.Streams.WiredStream.GetResponse.is(definition) || definition.data_stream_exists;
  const indexPatterns = (0, _streamsSchema.getIndexPatternsForStream)(definition.stream);
  const esqlQuery = indexPatterns ? `FROM ${indexPatterns.join(', ')}` : undefined;
  const useUrl = share.url.locators.useUrl;
  const discoverLink = useUrl(() => ({
    id: _common.DISCOVER_APP_LOCATOR,
    params: {
      query: {
        esql: esqlQuery || ''
      }
    }
  }), [esqlQuery]);
  if (!discoverLink || !dataStreamExists || !esqlQuery) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `streamsDiscoverActionButton-${definition.stream.name}`,
    href: discoverLink,
    iconType: "discoverApp",
    size: "xs",
    "aria-label": _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.openInDiscoverBadgeLabel', {
      defaultMessage: 'Open in Discover'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  });
}