"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsTab = DashboardsTab;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/group_stream_modification_flyout/dashboards_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DashboardsTab({
  formData,
  setFormData
}) {
  const {
    dependencies: {
      start: {
        dashboard: dashboardStart
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [query, setQuery] = (0, _react.useState)('');
  const [foundDashboards, setFoundDashboards] = (0, _react.useState)([]);
  const fetchDashboards = _react.default.useCallback(async (search = '') => {
    const findDashboardsService = await dashboardStart.findDashboardsService();
    const searchResults = await findDashboardsService.search({
      size: 10000,
      search
    });
    setFoundDashboards(searchResults.hits.map(hit => ({
      title: hit.attributes.title,
      id: hit.id
    })));
  }, [dashboardStart]);
  (0, _react.useEffect)(() => {
    fetchDashboards();
  }, [fetchDashboards]);
  const handleQueryChange = async event => {
    setQuery(event.target.value);
    fetchDashboards(event.target.value);
  };
  const onSelectionChange = newSelectedItems => {
    setFormData({
      ...formData,
      dashboards: newSelectedItems
    });
  };
  const availableDashboards = foundDashboards.filter(dashboard => {
    const matchesQuery = query === '' || dashboard.title.toLowerCase().includes(query.toLowerCase());
    const alreadySelected = formData.dashboards.some(item => item.id === dashboard.id);
    return matchesQuery && !alreadySelected;
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.selectedDashboardsLabel', {
    defaultMessage: 'Selected'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }), formData.dashboards.length === 0 ? _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.noSelectedDashboardsLabel', {
    defaultMessage: 'No dashboards selected'
  }) : formData.dashboards.map(dashboard => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: dashboard.id,
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.removeDashboardButtonLabel', {
      defaultMessage: 'Remove'
    }),
    onClick: () => {
      const newSelected = formData.dashboards.filter(d => d.id !== dashboard.id);
      onSelectionChange(newSelected);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 19
    }
  }, dashboard.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.availableDashboardsLabel', {
    defaultMessage: 'Available'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.dashboardFilterPlaceholder', {
      defaultMessage: 'Filter by title...'
    }),
    value: query,
    onChange: handleQueryChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), availableDashboards.length === 0 ? query ? _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.noDashboardsFoundLabel', {
    defaultMessage: 'No dashboards found'
  }) : _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.noAvailableDashboardsLabel', {
    defaultMessage: 'No available dashboards'
  }) : availableDashboards.map(dashboard => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: dashboard.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.addDashboardButtonLabel', {
      defaultMessage: 'Add'
    }),
    onClick: () => {
      onSelectionChange([...formData.dashboards, dashboard]);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 21
    }
  }, dashboard.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 19
    }
  }))))));
}