"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamFeaturesTable = StreamFeaturesTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared = require("../../shared");
var _feature_events_sparkline = require("./feature_events_sparkline");
var _feature_detail_expanded = require("./feature_detail_expanded");
var _table_title = require("./table_title");
var _use_stream_features_table = require("./hooks/use_stream_features_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_features/stream_features_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Helper function to generate unique copy name
const generateCopyName = (originalName, existingFeatures) => {
  const existingNames = new Set(existingFeatures.map(f => f.name));
  let copyNumber = 1;
  let copyName = `${originalName}-copy-${copyNumber}`;
  while (existingNames.has(copyName)) {
    copyNumber++;
    copyName = `${originalName}-copy-${copyNumber}`;
  }
  return copyName;
};
function StreamFeaturesTable({
  definition,
  features,
  selectedFeatureNames,
  setSelectedFeatureNames,
  setFeatures
}) {
  const [expandedFeatureNames, setExpandedFeatureNames] = (0, _react.useState)(new Set());
  const itemIdToExpandedRowMap = (0, _react.useMemo)(() => {
    const map = {};
    features.forEach(f => {
      if (expandedFeatureNames.has(f.name)) {
        map[f.name] = /*#__PURE__*/_react.default.createElement(_feature_detail_expanded.FeatureDetailExpanded, {
          feature: f,
          setFeatures: setFeatures,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 56,
            columnNumber: 23
          }
        });
      }
    });
    return map;
  }, [expandedFeatureNames, features, setFeatures]);
  const selectedFeatures = (0, _react.useMemo)(() => {
    return features.filter(f => selectedFeatureNames.has(f.name));
  }, [features, selectedFeatureNames]);
  const onSelectionChange = (0, _react.useCallback)(newSelectedFeatures => {
    setSelectedFeatureNames(new Set(newSelectedFeatures.map(f => f.name)));
  }, [setSelectedFeatureNames]);
  const {
    descriptionColumn
  } = (0, _use_stream_features_table.useStreamFeaturesTable)();
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.streams.streamFeatureTable.columns.title', {
      defaultMessage: 'Title'
    }),
    width: '15%',
    sortable: true,
    truncateText: true
  }, descriptionColumn, {
    field: 'filter',
    name: _i18n.i18n.translate('xpack.streams.streamFeatureTable.columns.filter', {
      defaultMessage: 'Filter'
    }),
    width: '25%',
    render: filter => {
      return /*#__PURE__*/_react.default.createElement(_shared.ConditionPanel, {
        condition: filter,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 16
        }
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.streams.streamFeatureTable.columns.eventsLast24Hours', {
      defaultMessage: 'Events (last 24 hours)'
    }),
    width: '20%',
    render: feature => {
      return /*#__PURE__*/_react.default.createElement(_feature_events_sparkline.FeatureEventsSparkline, {
        feature: feature,
        definition: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 16
        }
      });
    }
  }, {
    name: 'Actions',
    width: '5%',
    actions: [{
      name: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.cloneActionName', {
        defaultMessage: 'Clone'
      }),
      description: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.cloneActionDescription', {
        defaultMessage: 'Clone this feature'
      }),
      type: 'icon',
      icon: 'copy',
      onClick: feature => {
        setFeatures(prev => prev.concat({
          ...feature,
          name: generateCopyName(feature.name, features)
        }));
      }
    }, {
      name: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.editActionName', {
        defaultMessage: 'Edit'
      }),
      description: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.editActionDescription', {
        defaultMessage: 'Edit this feature'
      }),
      type: 'icon',
      icon: 'pencil',
      onClick: feature => {
        setExpandedFeatureNames(prev => new Set(prev).add(feature.name));
      }
    }, {
      name: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.deleteActionName', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.actions.deleteActionDescription', {
        defaultMessage: 'Delete this feature'
      }),
      type: 'icon',
      icon: 'trash',
      onClick: feature => {
        setFeatures(features.filter(selectedFeature => selectedFeature.name !== feature.name));
        setSelectedFeatureNames(new Set(Array.from(selectedFeatureNames).filter(selectedFeatureName => selectedFeatureName !== feature.name)));
        setExpandedFeatureNames(prev => {
          const next = new Set(prev);
          next.delete(feature.name);
          return next;
        });
      }
    }]
  }];
  const toggleDetails = (0, _react.useCallback)(feature => {
    setExpandedFeatureNames(prev => {
      const next = new Set(prev);
      if (next.has(feature.name)) {
        next.delete(feature.name);
      } else {
        next.add(feature.name);
      }
      return next;
    });
  }, []);
  const columnsWithExpandingRowToggle = [{
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.expand', {
      defaultMessage: 'Expand row'
    }))),
    mobileOptions: {
      header: false
    },
    render: feature => {
      const isExpanded = expandedFeatureNames.has(feature.name);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(feature),
        "aria-label": isExpanded ? _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.collapseDetails', {
          defaultMessage: 'Collapse details'
        }) : _i18n.i18n.translate('xpack.streams.streamFeaturesTable.columns.expandDetails', {
          defaultMessage: 'Expand details'
        }),
        iconType: isExpanded ? 'arrowDown' : 'arrowRight',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 11
        }
      });
    }
  }, ...columns];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_table_title.TableTitle, {
    pageIndex: 0,
    pageSize: 10,
    total: features.length,
    label: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.tableTitle', {
      defaultMessage: 'Features'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.streams.streamFeaturesTable.tableCaption', {
      defaultMessage: 'List of features'
    }),
    items: features,
    itemId: "name",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    columns: columnsWithExpandingRowToggle,
    selection: {
      selected: selectedFeatures,
      onSelectionChange
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }));
}