"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../../../hooks/use_kibana");
var _helpers = require("../../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/manual_ingest_pipeline/json_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JsonEditor = () => {
  var _fieldState$error;
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'processors',
    rules: {
      validate: value => {
        const parsedValue = typeof value === 'string' ? (0, _helpers.parseXJsonOrString)(value) : value;
        if (typeof value === 'string' && typeof parsedValue === 'string') {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsInvalidJSON', {
            defaultMessage: 'Invalid JSON format'
          });
        }
        if (!Array.isArray(parsedValue)) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsInvalidArray', {
            defaultMessage: 'Expected an array'
          });
        }
        const invalidProcessor = parsedValue.find(processor => {
          const processorType = Object.keys(processor)[0];
          return processorType && !_streamsSchema.elasticsearchProcessorTypes.includes(processorType);
        });
        if (invalidProcessor) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsInvalidProcessorType', {
            defaultMessage: 'Invalid processor type: {processorType}',
            values: {
              processorType: Object.keys(invalidProcessor)[0]
            }
          });
        }
        return undefined;
      }
    }
  });

  /**
   * To have the editor properly handle the set xjson language
   * we need to avoid the continuous parsing/serialization of the editor value
   * using a parallel state always setting a string make the editor format well the content.
   */
  const [value, setValue] = _react.default.useState(() => (0, _helpers.serializeXJson)(field.value, '[]'));
  const handleChange = newValue => {
    setValue(newValue);
    field.onChange((0, _helpers.parseXJsonOrString)(newValue));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsLabel', {
      defaultMessage: 'Ingest pipeline processors'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsHelpText",
      defaultMessage: 'A JSON-encoded array of {ingestPipelineProcessors}. {conditions} defined in the processor JSON take precedence over conditions defined in "Optional fields".',
      values: {
        ingestPipelineProcessors: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.ingest.processors,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsLabel', {
          defaultMessage: 'ingest pipeline processors'
        })),
        conditions: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.ingest.conditionalProcessor,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsConditionallyLabel', {
          defaultMessage: 'Conditions'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }),
    error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
    isInvalid: fieldState.invalid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: value,
    onChange: handleChange,
    languageId: "xjson",
    height: 200,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsAriaLabel', {
      defaultMessage: 'Ingest pipeline processors editor'
    }),
    options: {
      automaticLayout: true,
      wordWrap: 'on'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
};
exports.JsonEditor = JsonEditor;