"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorOutcomePreview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _grokUi = require("@kbn/grok-ui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _streamlang = require("@kbn/streamlang");
var _use_doc_viewer_setup = require("../../../hooks/use_doc_viewer_setup");
var _use_document_expansion = require("../../../hooks/use_document_expansion");
var _formatters = require("../../../util/formatters");
var _simulation_state_machine = require("./state_management/simulation_state_machine");
var _selectors = require("./state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _steps_state_machine = require("./state_management/steps_state_machine");
var _selectors2 = require("./state_management/stream_enrichment_state_machine/selectors");
var _doc_viewer_diff = require("./doc_viewer_diff");
var _empty_prompts = require("./empty_prompts");
var _shared = require("../shared");
var _utils = require("../stream_detail_routing/utils");
var _preview_table = require("../shared/preview_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/processor_outcome_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProcessorOutcomePreview = () => {
  const samples = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.context.samples);
  const previewDocuments = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectPreviewRecords)(snapshot.context));
  const areDataSourcesLoading = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.dataSourcesRefs.some(ref => {
    const snap = ref.getSnapshot();
    return snap.matches({
      enabled: 'loadingData'
    }) || snap.matches({
      enabled: 'debouncingChanges'
    });
  }));
  if ((0, _lodash.isEmpty)(samples)) {
    if (areDataSourcesLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center",
        alignItems: "center",
        style: {
          minHeight: 200
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_empty_prompts.NoProcessingDataAvailableEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(PreviewDocumentsGroupBy, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), (0, _lodash.isEmpty)(previewDocuments) ? /*#__PURE__*/_react.default.createElement(_empty_prompts.NoPreviewDocumentsEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(OutcomePreviewTable, {
    previewDocuments: previewDocuments,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }));
};
exports.ProcessorOutcomePreview = ProcessorOutcomePreview;
const formatter = (0, _formatters.getPercentageFormatter)();
const formatRateToPercentage = rate => rate ? formatter.format(rate) : undefined;
const PreviewDocumentsGroupBy = () => {
  const {
    changePreviewDocsFilter
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const previewDocsFilter = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewDocsFilter);
  const hasMetrics = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula;
    return !!((_state$context$simula = state.context.simulation) !== null && _state$context$simula !== void 0 && _state$context$simula.documents_metrics);
  });
  const simulationFailedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula2;
    return formatRateToPercentage((_state$context$simula2 = state.context.simulation) === null || _state$context$simula2 === void 0 ? void 0 : _state$context$simula2.documents_metrics.failed_rate);
  });
  const simulationSkippedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula3;
    return formatRateToPercentage((_state$context$simula3 = state.context.simulation) === null || _state$context$simula3 === void 0 ? void 0 : _state$context$simula3.documents_metrics.skipped_rate);
  });
  const simulationPartiallyParsedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula4;
    return formatRateToPercentage((_state$context$simula4 = state.context.simulation) === null || _state$context$simula4 === void 0 ? void 0 : _state$context$simula4.documents_metrics.partially_parsed_rate);
  });
  const simulationParsedRate = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula5;
    return formatRateToPercentage((_state$context$simula5 = state.context.simulation) === null || _state$context$simula5 === void 0 ? void 0 : _state$context$simula5.documents_metrics.parsed_rate);
  });
  const getFilterButtonPropsFor = filter => ({
    isToggle: previewDocsFilter === filter,
    isSelected: previewDocsFilter === filter,
    disabled: !hasMetrics,
    hasActiveFilters: previewDocsFilter === filter,
    onClick: () => changePreviewDocsFilter(filter)
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomeControlsAriaLabel', {
      defaultMessage: 'Filter for all, matching or unmatching previewed documents.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_all.id), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_all.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_parsed.id), {
    badgeColor: "success",
    numActiveFilters: simulationParsedRate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_parsed.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_partially_parsed.id), {
    badgeColor: "accent",
    numActiveFilters: simulationPartiallyParsedRate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_partially_parsed.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_skipped.id), {
    badgeColor: "accent",
    numActiveFilters: simulationSkippedRate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_skipped.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, getFilterButtonPropsFor(_simulation_state_machine.previewDocsFilterOptions.outcome_filter_failed.id), {
    badgeColor: "accent",
    numActiveFilters: simulationFailedRate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }), _simulation_state_machine.previewDocsFilterOptions.outcome_filter_failed.label)));
};
const OutcomePreviewTable = ({
  previewDocuments
}) => {
  var _draftProcessor$resou, _draftProcessor$resou4;
  const detectedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => {
    var _state$context$simula6;
    return (_state$context$simula6 = state.context.simulation) === null || _state$context$simula6 === void 0 ? void 0 : _state$context$simula6.detected_fields;
  });
  const streamName = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.streamName);
  const previewDocsFilter = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewDocsFilter);
  const previewColumnsSorting = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewColumnsSorting);
  const explicitlyEnabledPreviewColumns = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.explicitlyEnabledPreviewColumns);
  const explicitlyDisabledPreviewColumns = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.explicitlyDisabledPreviewColumns);
  const previewColumnsOrder = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.previewColumnsOrder);
  const originalSamples = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectOriginalPreviewRecords)(snapshot.context));
  const hasSimulatedRecords = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectHasSimulatedRecords)(snapshot.context));
  const shouldShowRowSourceAvatars = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.dataSourcesRefs.length >= 2);
  const currentProcessorSourceField = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => {
    const currentProcessorRef = state.context.stepRefs.find(stepRef => (0, _streamlang.isActionBlock)(stepRef.getSnapshot().context.step) && (0, _steps_state_machine.isStepUnderEdit)(stepRef.getSnapshot()));
    if (!currentProcessorRef) return undefined;
    const step = currentProcessorRef.getSnapshot().context.step;
    if (!(0, _streamlang.isActionBlock)(step)) return undefined;
    return (0, _simulation_state_machine.getSourceField)(step);
  });
  const docViewsRegistry = (0, _use_doc_viewer_setup.useDocViewerSetup)(true);
  const {
    setExplicitlyEnabledPreviewColumns,
    setExplicitlyDisabledPreviewColumns,
    setPreviewColumnsOrder,
    setPreviewColumnsSorting
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const allColumns = (0, _react.useMemo)(() => {
    return (0, _simulation_state_machine.getAllFieldsInOrder)(previewDocuments, detectedFields);
  }, [detectedFields, previewDocuments]);
  const draftProcessor = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => (0, _selectors2.selectDraftProcessor)(snapshot.context));
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(machineState => machineState.context.grokCollection);
  const grokMode = (draftProcessor === null || draftProcessor === void 0 ? void 0 : draftProcessor.processor) && 'action' in draftProcessor.processor && draftProcessor.processor.action === 'grok' && !(0, _lodash.isEmpty)(draftProcessor.processor.from) &&
  // NOTE: If a Grok expression attempts to overwrite the configured field (non-additive change) we defer to the standard preview table showing all columns
  !((_draftProcessor$resou = draftProcessor.resources) !== null && _draftProcessor$resou !== void 0 && _draftProcessor$resou.grokExpressions.some(grokExpression => {
    var _draftProcessor$proce;
    if (draftProcessor.processor && !(draftProcessor.processor.action === 'grok')) return false;
    const fieldName = (_draftProcessor$proce = draftProcessor.processor) === null || _draftProcessor$proce === void 0 ? void 0 : _draftProcessor$proce.from;
    return Array.from(grokExpression.getFields().values()).some(field => field.name === fieldName);
  }));
  const grokField = grokMode ? draftProcessor.processor.from : undefined;
  const validGrokField = grokField && allColumns.includes(grokField) ? grokField : undefined;
  const validCurrentProcessorSourceField = currentProcessorSourceField && allColumns.includes(currentProcessorSourceField) ? currentProcessorSourceField : undefined;
  const availableColumns = (0, _react.useMemo)(() => {
    let cols = (0, _simulation_state_machine.getTableColumns)({
      currentProcessorSourceField: validCurrentProcessorSourceField,
      detectedFields,
      previewDocsFilter
    });
    if (cols.length === 0) {
      // If no columns are detected, we fall back to all fields from the preview documents
      cols = allColumns;
    }
    // Filter out columns that are explicitly disabled
    const filteredCols = cols.filter(col => !explicitlyDisabledPreviewColumns.includes(col));
    // Add explicitly enabled columns if they are not already included and exist in allFields
    explicitlyEnabledPreviewColumns.forEach(col => {
      if (!filteredCols.includes(col) && allColumns.includes(col)) {
        filteredCols.push(col);
      }
    });
    return filteredCols;
  }, [allColumns, detectedFields, explicitlyDisabledPreviewColumns, explicitlyEnabledPreviewColumns, previewDocsFilter, validCurrentProcessorSourceField]);

  /**
   * If we are in Grok mode and the field matches an existing field,
   * we exclude the detected fields and only use the Grok field since it is highlighting extracted values
   */
  const grokColumns = (0, _react.useMemo)(() => validGrokField ? [validGrokField] : undefined, [validGrokField]);
  const previewColumns = grokColumns !== null && grokColumns !== void 0 ? grokColumns : availableColumns;
  const setVisibleColumns = (0, _react.useCallback)(visibleColumns => {
    if (visibleColumns.length === 0) {
      // If no columns are visible, we reset the explicitly enabled and disabled columns
      setExplicitlyDisabledPreviewColumns(allColumns);
      return;
    }
    // find which columns got added or removed comparing visibleColumns with the current displayColumns
    const addedColumns = visibleColumns.filter(col => !previewColumns.includes(col));
    if (addedColumns.length > 0) {
      setExplicitlyEnabledPreviewColumns([...explicitlyEnabledPreviewColumns, ...addedColumns.filter(col => !explicitlyEnabledPreviewColumns.includes(col))]);
    }
    const removedColumns = previewColumns.filter(col => !visibleColumns.includes(col));
    if (removedColumns.length > 0) {
      setExplicitlyDisabledPreviewColumns([...explicitlyDisabledPreviewColumns, ...removedColumns.filter(col => !explicitlyDisabledPreviewColumns.includes(col))]);
    }
    setPreviewColumnsOrder(visibleColumns);
  }, [allColumns, explicitlyDisabledPreviewColumns, explicitlyEnabledPreviewColumns, previewColumns, setExplicitlyDisabledPreviewColumns, setExplicitlyEnabledPreviewColumns, setPreviewColumnsOrder]);
  const renderCellValue = (0, _react.useMemo)(() => grokMode ? (document, columnId) => {
    const value = document[columnId];
    if (typeof value === 'string' && columnId === validGrokField) {
      var _draftProcessor$resou2, _draftProcessor$resou3;
      return /*#__PURE__*/_react.default.createElement(_grokUi.Sample, {
        grokCollection: grokCollection,
        draftGrokExpressions: (_draftProcessor$resou2 = (_draftProcessor$resou3 = draftProcessor.resources) === null || _draftProcessor$resou3 === void 0 ? void 0 : _draftProcessor$resou3.grokExpressions) !== null && _draftProcessor$resou2 !== void 0 ? _draftProcessor$resou2 : [],
        sample: value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 339,
          columnNumber: 17
        }
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0");
    }
  } : undefined, [(_draftProcessor$resou4 = draftProcessor.resources) === null || _draftProcessor$resou4 === void 0 ? void 0 : _draftProcessor$resou4.grokExpressions, grokCollection, grokMode, validGrokField]);
  const hits = (0, _react.useMemo)(() => {
    return (0, _utils.toDataTableRecordWithIndex)(previewDocuments);
  }, [previewDocuments]);
  const {
    currentDoc,
    selectedRowIndex,
    onRowSelected,
    setExpandedDoc
  } = (0, _use_document_expansion.useDocumentExpansion)(hits);
  const docViewerContext = (0, _react.useMemo)(() => ({
    originalSample: originalSamples && currentDoc ? originalSamples[currentDoc.index].document : undefined
  }), [currentDoc, originalSamples]);
  (0, _react.useEffect)(() => {
    if (docViewerContext.originalSample && hasSimulatedRecords) {
      // If the original sample is available, enable the diff tab - otherwise disable it
      docViewsRegistry.enableById(_doc_viewer_diff.DOC_VIEW_DIFF_ID);
    } else {
      docViewsRegistry.disableById(_doc_viewer_diff.DOC_VIEW_DIFF_ID);
    }
  }, [docViewerContext, docViewsRegistry, hasSimulatedRecords]);
  const rowSelectionContextValue = (0, _react.useMemo)(() => ({
    selectedRowIndex,
    onRowSelected
  }), [selectedRowIndex, onRowSelected]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_preview_table.RowSelectionContext.Provider, {
    value: rowSelectionContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.MemoPreviewTable, {
    documents: previewDocuments,
    originalSamples: originalSamples,
    showRowSourceAvatars: shouldShowRowSourceAvatars,
    displayColumns: previewColumns,
    rowHeightsOptions: validGrokField ? staticRowHeightsOptions : undefined,
    toolbarVisibility: true,
    setVisibleColumns: setVisibleColumns,
    sorting: previewColumnsSorting,
    setSorting: setPreviewColumnsSorting,
    columnOrderHint: previewColumnsOrder,
    renderCellValue: renderCellValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_doc_viewer_diff.DocViewerContext.Provider, {
    value: docViewerContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.PreviewFlyout, {
    currentDoc: currentDoc,
    hits: hits,
    setExpandedDoc: setExpandedDoc,
    docViewsRegistry: docViewsRegistry,
    streamName: streamName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 9
    }
  })));
};
const staticRowHeightsOptions = {
  defaultHeight: 'auto'
};