"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaChangesReviewModal = SchemaChangesReviewModal;
exports.getChanges = getChanges;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactField = require("@kbn/react-field");
var _streamsSchema = require("@kbn/streams-schema");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _reactHooks = require("@kbn/react-hooks");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _errors = require("../../../util/errors");
var _constants = require("./constants");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/schema_changes_review_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SchemaChangesReviewModal({
  fields,
  streamType,
  definition,
  storedFields,
  submitChanges,
  onClose
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const changes = _react.default.useMemo(() => getChanges(fields, storedFields), [fields, storedFields]);
  const existingFields = _react.default.useMemo(() => {
    // Fields that have esType (from Field Caps API) - these are existing in ES
    return changes.filter(field => field.esType && field.status === 'mapped');
  }, [changes]);
  const autoMappedFields = _react.default.useMemo(() => {
    // Fields that have source (from metadata service) but no esType - these are new and auto-mapped
    return changes.filter(field => field.status === 'mapped' && field.source && !field.esType);
  }, [changes]);
  const reviewRequiredFields = _react.default.useMemo(() => {
    // Fields that need manual review (unmapped)
    return changes.filter(field => field.status === 'unmapped');
  }, [changes]);

  // Sort changes to show review required first, then auto-mapped, then existing
  const sortedChanges = _react.default.useMemo(() => {
    return [...changes].sort((a, b) => {
      const getFieldPriority = field => {
        if (reviewRequiredFields.includes(field)) return 1; // Highest priority
        if (autoMappedFields.includes(field)) return 2;
        if (existingFields.includes(field)) return 3; // Lowest priority
        return 4; // Fallback
      };
      return getFieldPriority(a) - getFieldPriority(b);
    });
  }, [changes, reviewRequiredFields, autoMappedFields, existingFields]);
  const [{
    loading
  }, handleSubmit] = (0, _useAsyncFn.default)(async () => {
    await submitChanges();
    onClose();
  }, [submitChanges, onClose]);
  const [hasSimulationErrors, setHasSimulationErrors] = _react.default.useState(false);
  const [simulationError, setSimulationError] = _react.default.useState(null);
  const [isSimulating, setIsSimulating] = _react.default.useState(false);
  (0, _react.useEffect)(() => {
    async function simulate() {
      setIsSimulating(true);
      setSimulationError(null);
      const mappedFields = changes.filter(field => field.status === 'mapped').map(field => ({
        ...(0, _utils.convertToFieldDefinitionConfig)(field),
        name: field.name
      }));
      try {
        const simulationResults = await streamsRepositoryClient.fetch('POST /internal/streams/{name}/schema/fields_simulation', {
          signal,
          params: {
            path: {
              name: definition.stream.name
            },
            body: {
              field_definitions: mappedFields
            }
          }
        });
        if (simulationResults.status === 'failure') {
          setHasSimulationErrors(true);
          setSimulationError(simulationResults.simulationError);
        }
      } catch (err) {
        setHasSimulationErrors(true);
        setSimulationError((0, _errors.getFormattedError)(err).message);
      } finally {
        setIsSimulating(false);
      }
    }
    simulate();
  }, [changes, streamsRepositoryClient, signal, definition.stream.name]);
  const confirmChangesTitle = _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.title', {
    defaultMessage: 'Confirm changes'
  });
  const fieldColumns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnField', {
      defaultMessage: 'Field'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name)
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnType', {
      defaultMessage: 'type'
    }),
    render: (type, field) => {
      // Prioritize showing esType if available and different from our supported type
      if (field.esType && (!type || type === 'system')) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
          type: field.esType,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 15
          }
        }), field.esType);
      }
      if (!type || field.status === 'unmapped') {
        // Only show <dynamic> for classic streams with unmapped fields
        if (streamType === 'classic') {
          const dynamicText = _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.dynamicText', {
            defaultMessage: 'Dynamic'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 184,
              columnNumber: 20
            }
          }, dynamicText);
        }
        // For wired streams, don't show <dynamic> for unmanaged fields
        return null;
      }

      // Handle unknown types gracefully
      const typeInfo = _constants.FIELD_TYPE_MAP[type];
      const typeLabel = typeInfo ? typeInfo.label : type;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 13
        }
      }), typeLabel);
    }
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnStatus', {
      defaultMessage: 'Status'
    }),
    width: '200px',
    render: (status, field) => {
      if (reviewRequiredFields.includes(field)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "warning",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 211,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.fieldColumns.newReviewRequiredBadgeLabel', {
          defaultMessage: 'Review required'
        }));
      }
      if (autoMappedFields.includes(field)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "success",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.fieldColumns.newAutomaticallyMappedBadgeLabel', {
          defaultMessage: 'Automatically mapped'
        }));
      }
      if (existingFields.includes(field)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 229,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.fieldColumns.existingBadgeLabel', {
          defaultMessage: 'Existing'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 16
        }
      }, status);
    }
  }, {
    field: 'source',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnSource', {
      defaultMessage: 'Source'
    }),
    render: (source, field) => {
      // Don't show source for existing fields (those that are truly from ES)
      if (existingFields.includes(field)) {
        return null;
      }
      if (!source) return null;
      const sourceLabels = {
        ecs: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.sourceLabel.ecs', {
          defaultMessage: 'ECS Standard'
        }),
        otel: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.sourceLabel.otel', {
          defaultMessage: 'OpenTelemetry'
        })
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 11
        }
      }, sourceLabels[source] || source);
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: 800,
    "aria-label": confirmChangesTitle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }, confirmChangesTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }, _streamsSchema.Streams.WiredStream.GetResponse.is(definition) ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.affectsAllStreamsCalloutTitle', {
      defaultMessage: 'Schema edits affect all dependent streams.'
    }),
    iconType: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.fieldsWillBeUpdatedText', {
    defaultMessage: 'Some fields below will be updated.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  }), hasSimulationErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.simulationErrorCalloutTitle', {
      defaultMessage: 'Some fields are failing when simulating ingestion.'
    }),
    iconType: "warning",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 13
    }
  }, simulationError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: sortedChanges,
    columns: fieldColumns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "streamsAppSchemaChangesReviewModalCancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.schemaEditor.confirmChangesModal.cancelButton",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: handleSubmit,
    isLoading: loading || isSimulating,
    disabled: isSimulating || hasSimulationErrors,
    "data-test-subj": "streamsAppSchemaChangesReviewModalSubmitButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  }, isSimulating ? _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.verifyingChangesText', {
    defaultMessage: 'Verifying changes'
  }) : confirmChangesTitle)));
}
function getChanges(fields, storedFields) {
  const addedFields = fields.filter(field => (field.status === 'mapped' || field.status === 'unmapped') && !storedFields.some(stored => stored.name === field.name));
  const changedFields = fields.filter(field => {
    const stored = storedFields.find(storedField => field.status !== 'inherited' && storedField.name === field.name);
    return stored && !(0, _lodash.isEqual)(stored, field);
  });
  return [...addedFields, ...changedFields];
}