"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldActionsCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _streams_app_context_provider = require("../../streams_app_context_provider");
var _flyout = require("./flyout");
var _schema_editor_context = require("./schema_editor_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/field_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldActionsCell = ({
  field
}) => {
  const context = (0, _use_kibana.useKibana)();
  const schemaEditorContext = (0, _schema_editor_context.useSchemaEditorContext)();
  const {
    core
  } = context;
  const contextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fieldsTableContextMenuPopover'
  });
  const [popoverIsOpen, {
    off: closePopover,
    toggle
  }] = (0, _reactHooks.useBoolean)(false);
  const panels = (0, _react.useMemo)(() => {
    const {
      onFieldUpdate,
      stream,
      withFieldSimulation
    } = schemaEditorContext;
    let actions = [];
    const openFlyout = (props = {
      isEditingByDefault: false
    }) => {
      const overlay = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_streams_app_context_provider.StreamsAppContextProvider, {
        context: context,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_flyout.SchemaEditorFlyout, (0, _extends2.default)({
        field: field,
        onClose: () => overlay.close(),
        onStage: onFieldUpdate,
        stream: stream,
        withFieldSimulation: withFieldSimulation
      }, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 13
        }
      }))), core), {
        maxWidth: 500
      });
    };
    const viewFieldAction = {
      name: _i18n.i18n.translate('xpack.streams.actions.viewFieldLabel', {
        defaultMessage: 'View field'
      }),
      onClick: () => openFlyout()
    };
    switch (field.status) {
      case 'mapped':
        actions = [viewFieldAction, {
          name: _i18n.i18n.translate('xpack.streams.actions.editFieldLabel', {
            defaultMessage: 'Edit field'
          }),
          onClick: () => openFlyout({
            isEditingByDefault: true
          })
        }, {
          name: _i18n.i18n.translate('xpack.streams.actions.unpromoteFieldLabel', {
            defaultMessage: 'Unmap field'
          }),
          onClick: () => {
            onFieldUpdate({
              name: field.name,
              parent: field.parent,
              status: 'unmapped'
            });
          }
        }];
        break;
      case 'unmapped':
        actions = [viewFieldAction, {
          name: _i18n.i18n.translate('xpack.streams.actions.mapFieldLabel', {
            defaultMessage: 'Map field'
          }),
          onClick: () => openFlyout({
            isEditingByDefault: true
          })
        }];
        break;
      case 'inherited':
        actions = [viewFieldAction];
        break;
    }
    return [{
      id: 0,
      title: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableActionsTitle', {
        defaultMessage: 'Field actions'
      }),
      items: actions.map(action => ({
        name: action.name,
        onClick: () => {
          action.onClick();
          closePopover();
        }
      }))
    }];
  }, [closePopover, context, core, field, schemaEditorContext]);
  if (field.type === 'system') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: contextMenuPopoverId,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableActionsTriggerButton', {
        defaultMessage: 'Open actions menu'
      }),
      "data-test-subj": "streamsAppActionsButton",
      iconType: "boxesVertical",
      onClick: toggle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }),
    isOpen: popoverIsOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
};
exports.FieldActionsCell = FieldActionsCell;