"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportContentPackFlyout = ExportContentPackFlyout;
var _react = _interopRequireWildcard(require("react"));
var _filesaver = require("@elastic/filesaver");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _objects_list = require("./objects_list");
var _requests = require("./requests");
var _manifest = require("./manifest");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/content/export_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ExportContentPackFlyout({
  definition,
  onExport,
  onClose
}) {
  var _significantEvents$av, _exportResponse$conte;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    core: {
      http,
      notifications
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    features: {
      significantEvents
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const [manifest, setManifest] = (0, _react.useState)();
  const {
    value: exportResponse,
    loading: isLoadingContentPack
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    if (!definition) {
      return;
    }
    const contentPackRaw = await streamsRepositoryClient.fetch('POST /api/streams/{name}/content/export 2023-10-31', {
      params: {
        path: {
          name: definition.stream.name
        },
        body: {
          name: definition.stream.name,
          description: '',
          version: '1.0.0',
          include: {
            objects: {
              all: {}
            }
          }
        }
      },
      signal
    });
    const contentPack = await (0, _requests.previewContent)({
      http,
      definition,
      file: new File([contentPackRaw], `${definition.stream.name}-1.0.0.zip`, {
        type: 'application/zip'
      })
    });
    setManifest({
      name: contentPack.name,
      version: contentPack.version,
      description: contentPack.description
    });
    return {
      contentPack
    };
  }, [definition, streamsRepositoryClient, http]);
  const [includedObjects, setIncludedObjects] = (0, _react.useState)({
    objects: {
      all: {}
    }
  });
  const [isExporting, setIsExporting] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboard.exportContent', {
    defaultMessage: 'Export content pack'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, isLoadingContentPack ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }) : !exportResponse ? null : exportResponse.contentPack.entries ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, manifest ? /*#__PURE__*/_react.default.createElement(_manifest.ContentPackMetadata, {
    manifest: manifest,
    onChange: setManifest,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 25
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_objects_list.ContentPackObjectsList, {
    objects: exportResponse.contentPack.entries,
    onSelectionChange: setIncludedObjects,
    significantEventsAvailable: (_significantEvents$av = significantEvents === null || significantEvents === void 0 ? void 0 : significantEvents.available) !== null && _significantEvents$av !== void 0 ? _significantEvents$av : false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.exportContentPackFlyout.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppModalFooterButton",
    isLoading: isExporting,
    isDisabled: isLoadingContentPack || !manifest || (0, _helpers.isEmptyContentPack)((_exportResponse$conte = exportResponse === null || exportResponse === void 0 ? void 0 : exportResponse.contentPack.entries) !== null && _exportResponse$conte !== void 0 ? _exportResponse$conte : []) || !(0, _helpers.hasSelectedObjects)(includedObjects),
    fill: true,
    onClick: async () => {
      if (!exportResponse || !manifest) {
        return;
      }
      setIsExporting(true);
      try {
        const contentPack = await streamsRepositoryClient.fetch('POST /api/streams/{name}/content/export 2023-10-31', {
          params: {
            path: {
              name: definition.stream.name
            },
            body: {
              ...manifest,
              include: includedObjects
            }
          },
          signal: new AbortController().signal
        });
        (0, _filesaver.saveAs)(new Blob([contentPack], {
          type: 'application/zip'
        }), `${manifest.name}-${manifest.version}.zip`);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.streams.exportContentPackFlyout.exportSuccess', {
          defaultMessage: 'Export completed'
        }));
        onExport();
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.streams.failedToExportContentError', {
            defaultMessage: 'Failed to export content pack'
          })
        });
      } finally {
        setIsExporting(false);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.exportContentPackFlyout.exportContentPack', {
    defaultMessage: 'Export content pack'
  }))))));
}