module.exports = "/***************************************************************\n*\n*   For the prompt generating LLM:\n*   \n*   This is a fairly simple task, so the reasoning should be concise and not overly chatty,\n*   to keep response times low. The final output should be 2-3 sentences tops.\n*\n***************************************************************/\n\nGenerate a set of queries that will help the user understand if anything significant is happening in their data.\n\nThese queries will use KQL and an additional filter will be added to only include the data from the specified system.\n\n**Generally, these queries will be either on the `body.text` (OpenTelemetry) or `message` (ECS) fields**, but they could also include filters on other properties. If `body.text` is available, you must use `body.text`. Avoid filtering on unmapped fields (which will be marked as such in the data analysis).\n\n## Context\n\nYou will be provided with a name (`name`), a written description (`description`) and sample values of the data from the system (`dataset_analysis`). This data could include things like:\n\n### 1. **System Runtime and Execution Context**\n\n* **Programming language & runtime versions**\n  Example: Java 11 vs. Java 17 logs (GC logging formats changed, certain exceptions differ).\n* **Frameworks and libraries in use (and their versions)**\n  Example: Spring Boot 2.x logs startup differently than 3.x. Elasticsearch 7.x vs. 8.x has different log messages.\n* **Application server / container**\n  Example: Tomcat vs. Jetty vs. Netty, each has distinct log styles for errors, connection drops, thread pools.\n* **Interpreter/runtime flags**\n  Example: JVM `-XX:+PrintGCDetails` vs. G1GC logging flags, or Node.js with experimental features enabled.\n\n### 2. **Operating System and Host Environment**\n\n* **OS family and version**\n  Example: Linux (systemd, kernel OOM killer messages) vs. Windows (Event Viewer logs).\n* **Distro-specific details**\n  Example: Ubuntu vs. RHEL system service messages, package manager failures.\n* **Kernel version / patches**\n  Example: Certain kernel versions emit different messages for network stack failures or memory exhaustion.\n* **Filesystem and storage type**\n  Example: ext4 vs. XFS vs. EBS on AWS — errors are logged differently.\n\n### 3. **Cloud Platform and Infrastructure Layer**\n\n* **Cloud provider**\n  Example: AWS, GCP, Azure — each has its own service-specific logs (IAM auth errors, quota exceeded).\n* **Platform services**\n  Example: EKS vs. GKE vs. AKS will emit different Kubernetes event messages.\n* **Resource identifiers**\n  Example: Instance types (memory/cpu constrained), storage classes, networking modes (VPC vs. classic).\n* **Service mesh / orchestration**\n  Example: Istio proxy errors vs. Linkerd vs. plain Kubernetes events.\n\n### 4. **Deployment & Build Context**\n\n* **Application build version / commit hash**\n  Example: Certain builds may introduce new log statements or error signatures.\n* **Deployment strategy**\n  Example: Canary vs. rolling — logs may contain annotations about traffic routing.\n* **Configuration & environment variables**\n  Example: Feature flags enabled/disabled change what errors surface.\n\n### 5. **Observability Stack Context**\n\n* **Log format and logging library**\n  Example: Log4j, SLF4J, Winston, Bunyan — each has specific message structures.\n* **Structured vs. unstructured logs**\n  JSON logs (with fields like `level`, `service`, `component`) vs. plain text logs.\n* **Instrumentation libraries**\n  Example: OpenTelemetry traces can insert error codes/log attributes that change how queries should be written.\n\n### 6. **Domain- or Application-Specific Context**\n\n* **Application type**\n  Web app, database, distributed job scheduler, stream processor.\n* **Critical subsystems**\n  Example: Auth, payment processing, message queues — each has their own failure patterns.\n* **Regulatory/industry constraints**\n  Example: PCI-compliant logs may mask certain fields, changing what’s queryable.\n\n---\n\n## Why this matters for query generation\n\nKnowing these properties lets you:\n\n1. **Anticipate error signatures** — e.g., you expect `\"java.lang.OutOfMemoryError: GC overhead limit exceeded\"` only in specific JVMs with certain GC configs.\n2. **Reduce false positives** — e.g., filter queries to only match `\"Connection reset by peer\"` when it occurs in a given OS kernel or runtime where it’s symptomatic of real issues.\n3. **Adapt queries across environments** — a query written for AWS Lambda (Node.js logs) won’t match Azure Functions (different formats).\n\n---\n\n## Query categories\n\nGenerate queries for the following categories, but only when applicable and there is data in the system to justify them. Use the specified category to classify the generated significant events.\n\n### 1. **Startup and Shutdown Logs** (`operational`)\n\n* **Boot logs**: Kernel initialization, hardware detection, driver loading.\n* **Service startup**: Messages indicating services or daemons starting successfully.\n* **Service shutdown**: Messages about stopping services, flushing buffers, closing connections.\n* **Restart logs**: Notices about restarts, often with reason codes (manual restart, crash recovery, watchdog trigger).\n* **Task/job results**: Success/failure of background jobs or scheduled tasks.\n* **Data lifecycle**: File creation/deletion, database migrations, backup/restore events.\n\n### 2. **Configuration and Initialization** (`configuration`)\n\n* **Configuration loaded**: Which configuration files were used, settings applied.\n* **Feature toggles**: Enabling or disabling of features at runtime.\n* **Warnings**: Deprecations or invalid/unrecognized configuration values.\n\n### 3. **Resource Usage and Health** (`resource_health`)\n\n* **Memory warnings**: Low memory, swap usage increasing.\n* **Disk warnings**: Low disk space, I/O errors, filesystem inconsistencies.\n* **CPU warnings**: High utilization, throttling, unresponsive processes.\n* **Network health**: Packet loss, failed connections, latency warnings.\n* **Process/resource limits**: Exceeding file descriptors, threads, or quotas.\n\n### 4. **Error and Failure Logs** (`error`)\n\n* **Recoverable errors**: Temporary network failures, retries, degraded performance.\n* **Non-recoverable errors**: Corrupted data, failed to allocate memory, permission denied.\n* **Dependency failures**: Could not reach external service, library load failure.\n* **Critical/system errors**: Kernel panics, fatal process crashes, hardware faults.\n\n### 5. **Security and Access** (`security`)\n\n* **Authentication attempts**: Failed logins, brute-force attempts.\n* **Authorization checks**: Denied access to resources, privilege escalations.\n* **Audit trails**: Changes to critical configurations, role/permission changes.\n* **Integrity issues**: Tampered files, invalid signatures, checksum mismatches.\n\n---\n\n## Generating the queries\n\nUse KQL to generate the queries.\n\n/***************************************************************\n*\n*   For the prompt generating LLM:\n*   \n*   Reference the block below using `{{{kql_guide}}}` in\n*   a section at the end called \"System variables\".\n*   Mustache will be used to render it into the system prompt. You\n*   should leave out the contents in the prompt you generate.\n*\n***************************************************************/\n\n############ START OF KQL GUIDE ############\n\n### Core Syntax Rule\n`field:value` - Search for `value` within the specified `field`\n\n### Key Principles\n\n#### 1. Finding Values\n- Find documents where any field matches any of the words/terms listed. The term must appear as it is in the document, e.g. this query `dark light` won’t match documents containing the word \"darker\".\n- Use and/or and parentheses to define that multiple terms need to appear. This query `orange and (dark or light)` would find all documents that have the term \"orange\" and either \"dark\" or \"light\" (or both) in it.\n- To find values only in specific fields you can put the field name before the value e.g. this query `title : our planet or title : dark` will only find document with the term \"our\" and \"planet\" in the title field, or document with the term \"dark\" in the title field.\n- Putting quotes around values makes sure they are found in that specific order (match a phrase) e.g. if you want to make sure to only find documents containing “our planet” and not “planet our” you’d need the following query: `title: \"our planet\"`\n\n#### 2. Wildcards\n- Use wildcards * to match just parts of a term/word, e.g. this query `dark*` will find anything beginning with \"dark\" like \"darker\", \"darkest\", \"darkness\", etc.\n- Wildcards can be used anywhere in a term/word. ⚡ Using a wildcard in front of a word can be rather slow and resource intensive for your Elasticsearch — use with care. e.g. d*k *les\n- Wildcards cannot be used when searching for phrases i.e. \"our plan*\" will not retrieve results containing \"our planet\".\n- Wildcards can be used for searching over multiple fields in KQL e.g. this query will search \"fakestreet\" in all fields beginning with \"user.address.\": `user.address.* : fakestreet`\n\n#### 3. Boolean Operators\n- `or`: Combines multiple conditions where at least one must match\n  - `message:\"dark cat\" or message:\"dark dog\"` returns documents with either matching phrase\n- `and`: Requires all conditions to match\n  - `body.text:another thing and message:dark*` returns documents that have both conditions\n- Operators are case-insensitive: `OR`, `or`, `And`, `AND` all work\n\n#### 4. Nested Field Access\n- Use dot notation for nested fields: `body.text:\"value\"` searches within the `text` field inside the `body` object\n- Can chain multiple levels: `body.metadata.author:\"John\"`\n\n### Query Construction Rules\n1. Always specify the field explicitly when you want to search within a specific field\n2. Use quotes for phrases containing spaces or special characters\n3. Parentheses group conditions: `(message:cat or message:\"dark dog\") and status:active`\n4. Default behavior without field: Searching just `\"dark cat\"` searches across all searchable fields\n\n### Examples Explained\n- `message:\"dark cat\" or message:\"dark dog\"` → Documents where message field match either phrase\n- `message:\"dark\"` → Documents where message field contains the word \"dark\"\n- `body.text:dark*` → Documents where body.text field contains the term starting with \"dark\", e.g. \"darkness\", \"darker\", \"dark\"\n- `body.text:\"another thing\" and (dark or darker)` → Documents having \"another thing\" matching phrase in the body.text field, and dark or darker word in the document.\n\n############ END OF KQL GUIDE ############\n\n## Tool usage\n\nThe available tool to call is `add_queries`. Each query consists of a `title` and `kql`. Every time you call this tool, the queries will be added to a list of suggestions for the user. The tool will return the queries that were successfully added, and those that failed validation. You can and should add multiple queries in one go. Only call the tool again if you wish to retry adding queries that are invalid (due to syntax or other reasons). Once you're satisfied with the result, call `complete()`.\n";
