"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWebhookSecretHeadersKeyRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/actions-plugin/server");
var _boom = require("@hapi/boom");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWebhookSecretHeadersKeyRoute = (router, getStartServices) => {
  router.get({
    path: `${_common.INTERNAL_BASE_STACK_CONNECTORS_API_PATH}/{id}/secret_headers`,
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because it relies on the authorization model inside the actions client.'
      }
    },
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    },
    options: {
      access: 'internal'
    }
  }, async (ctx, req, res) => {
    try {
      var _decryptedConnector$a;
      const {
        id
      } = req.params;
      const [, {
        encryptedSavedObjects,
        actions,
        spaces
      }] = await getStartServices();
      const actionsClient = await actions.getActionsClientWithRequest(req);
      const connector = await actionsClient.get({
        id
      });
      const spaceId = spaces.spacesService.getSpaceId(req);
      if (!['.webhook', '.cases-webhook'].includes(connector.actionTypeId)) {
        return res.badRequest({
          body: {
            message: 'Connector must be a webhook or cases webhook'
          }
        });
      }
      const encryptedClient = encryptedSavedObjects.getClient({
        includedHiddenTypes: [_server.ACTION_SAVED_OBJECT_TYPE]
      });
      const decryptedConnector = await encryptedClient.getDecryptedAsInternalUser(_server.ACTION_SAVED_OBJECT_TYPE, id, {
        namespace: spaceId
      });
      const secretHeaders = ((_decryptedConnector$a = decryptedConnector.attributes.secrets) === null || _decryptedConnector$a === void 0 ? void 0 : _decryptedConnector$a.secretHeaders) || {};
      const secretHeadersArray = Object.keys(secretHeaders) || [];
      return res.ok({
        body: secretHeadersArray
      });
    } catch (error) {
      if ((0, _boom.isBoom)(error)) {
        return res.customError({
          statusCode: error.output.statusCode,
          body: {
            message: error.output.payload.message
          }
        });
      }
      return res.customError({
        statusCode: 500,
        body: {
          message: error.message
        }
      });
    }
  });
};
exports.getWebhookSecretHeadersKeyRoute = getWebhookSecretHeadersKeyRoute;