"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CasesWebhookConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _cases_webhook.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "EmailConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _email.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "IndexConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _es_index.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "JiraConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _jira.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "OpsgenieConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _opsgenie.OpsgenieConnectorTypeId;
  }
});
Object.defineProperty(exports, "PagerDutyConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _pagerduty.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServerLogConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _server_log.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServiceNowITOMConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _servicenow_itom.ServiceNowITOMConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServiceNowITSMConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _servicenow_itsm.ServiceNowITSMConnectorTypeId;
  }
});
Object.defineProperty(exports, "ServiceNowSIRConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _servicenow_sir.ServiceNowSIRConnectorTypeId;
  }
});
Object.defineProperty(exports, "SlackApiConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _constants.SLACK_API_CONNECTOR_ID;
  }
});
Object.defineProperty(exports, "SlackWebhookConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _slack.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "TeamsConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _teams.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "WebhookConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _webhook.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "XmattersConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _xmatters.ConnectorTypeId;
  }
});
Object.defineProperty(exports, "getSwimlaneConnectorType", {
  enumerable: true,
  get: function () {
    return _swimlane.getConnectorType;
  }
});
exports.registerConnectorTypes = registerConnectorTypes;
var _jiraServiceManagement = require("./jira-service-management");
var _microsoft_defender_endpoint = require("./microsoft_defender_endpoint");
var _cases_webhook = require("./cases_webhook");
var _jira = require("./jira");
var _servicenow_itsm = require("./servicenow_itsm");
var _servicenow_sir = require("./servicenow_sir");
var _servicenow_itom = require("./servicenow_itom");
var _tines = require("./tines");
var _resilient = require("./resilient");
var _torq = require("./torq");
var _email = require("./email");
var _es_index = require("./es_index");
var _openai = require("./openai");
var _bedrock = require("./bedrock");
var _gemini = require("./gemini");
var _inference = require("./inference");
var _pagerduty = require("./pagerduty");
var _swimlane = require("./swimlane");
var _server_log = require("./server_log");
var _slack = require("./slack");
var _slack_api = require("./slack_api");
var _webhook = require("./webhook");
var _xmatters = require("./xmatters");
var _teams = require("./teams");
var _d3security = require("./d3security");
var _thehive = require("./thehive");
var _xsoar = require("./xsoar");
var _opsgenie = require("./opsgenie");
var _sentinelone = require("./sentinelone");
var _crowdstrike = require("./crowdstrike");
var _constants = require("../../common/slack_api/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConnectorTypes({
  actions,
  publicBaseUrl,
  experimentalFeatures
}) {
  actions.registerType((0, _email.getConnectorType)({
    publicBaseUrl
  }));
  actions.registerType((0, _es_index.getConnectorType)());
  actions.registerType((0, _pagerduty.getConnectorType)());
  actions.registerType((0, _swimlane.getConnectorType)());
  actions.registerType((0, _server_log.getConnectorType)());
  actions.registerType((0, _slack.getConnectorType)({}));
  actions.registerType((0, _slack_api.getConnectorType)());
  actions.registerType((0, _webhook.getConnectorType)());
  actions.registerType((0, _cases_webhook.getConnectorType)());
  actions.registerType((0, _xmatters.getConnectorType)());
  actions.registerType((0, _servicenow_itsm.getServiceNowITSMConnectorType)());
  actions.registerType((0, _servicenow_sir.getServiceNowSIRConnectorType)());
  actions.registerType((0, _servicenow_itom.getServiceNowITOMConnectorType)());
  actions.registerType((0, _jira.getConnectorType)());
  actions.registerType((0, _teams.getConnectorType)());
  actions.registerType((0, _torq.getActionType)());
  actions.registerSubActionConnectorType((0, _opsgenie.getOpsgenieConnectorType)());
  actions.registerSubActionConnectorType((0, _jiraServiceManagement.getJiraServiceManagementConnectorType)());
  actions.registerSubActionConnectorType((0, _tines.getTinesConnectorType)());
  actions.registerSubActionConnectorType((0, _openai.getConnectorType)());
  actions.registerSubActionConnectorType((0, _bedrock.getConnectorType)());
  actions.registerSubActionConnectorType((0, _gemini.getConnectorType)());
  actions.registerSubActionConnectorType((0, _d3security.getConnectorType)());
  actions.registerSubActionConnectorType((0, _resilient.getResilientConnectorType)());
  actions.registerSubActionConnectorType((0, _thehive.getConnectorType)());
  actions.registerSubActionConnectorType((0, _xsoar.getConnectorType)());
  if (experimentalFeatures.sentinelOneConnectorOn) {
    actions.registerSubActionConnectorType((0, _sentinelone.getSentinelOneConnectorType)());
  }
  if (experimentalFeatures.crowdstrikeConnectorOn) {
    actions.registerSubActionConnectorType((0, _crowdstrike.getCrowdstrikeConnectorType)(experimentalFeatures));
  }
  if (!experimentalFeatures.inferenceConnectorOff) {
    actions.registerSubActionConnectorType((0, _inference.getConnectorType)());
  }
  actions.registerSubActionConnectorType((0, _microsoft_defender_endpoint.getMicrosoftDefenderEndpointConnectorType)());
}