"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../common/openai/constants");
var _constants2 = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/openai/params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  messageVariables,
  executionMode,
  errors
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const typedActionConnector = actionConnector;
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants.SUB_ACTION.TEST : _constants.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  (0, _react.useEffect)(() => {
    if (!subActionParams) {
      const sampleBody = (0, _constants2.getDefaultBody)(typedActionConnector === null || typedActionConnector === void 0 ? void 0 : typedActionConnector.config);
      editAction('subActionParams', {
        body: sampleBody
      }, index);
    }
  }, [typedActionConnector === null || typedActionConnector === void 0 ? void 0 : typedActionConnector.config, editAction, index, subActionParams]);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.genAi.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.stackConnectors.components.genAi.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.body,
    onDocumentsChange: json => {
      editSubActionParams({
        body: json
      });
    },
    onBlur: () => {
      if (!body) {
        editSubActionParams({
          body: ''
        });
      }
    },
    dataTestSubj: "genAi-bodyJsonEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = ParamsFields;
module.exports = exports.default;