"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SNStoreLink = exports.SNStoreButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/lib/servicenow/sn_store_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getStoreURL = appId => `https://store.servicenow.com/sn_appstore_store.do#!/store/application/${appId}`;
const SNStoreButtonComponent = ({
  color,
  appId = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: getStoreURL(appId),
    color: color,
    iconSide: "right",
    iconType: "popout",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, i18n.VISIT_SN_STORE);
};
const SNStoreButton = exports.SNStoreButton = /*#__PURE__*/(0, _react.memo)(SNStoreButtonComponent);
const SNStoreLinkComponent = ({
  appId = ''
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: getStoreURL(appId),
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, i18n.VISIT_SN_STORE);
const SNStoreLink = exports.SNStoreLink = /*#__PURE__*/(0, _react.memo)(SNStoreLinkComponent);