"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseAlert = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _display_more_options = require("./display_more_options");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/jira-service-management/close_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdditionalOptions = ({
  subActionParams,
  editOptionalSubAction,
  index,
  messageVariables
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "jsm-source-row",
    fullWidth: true,
    label: i18n.SOURCE_FIELD_LABEL,
    helpText: i18n.JIRA_SERVICE_MANAGEMENT_SOURCE_HELP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'source',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.source,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "jsm-user-row",
    fullWidth: true,
    label: i18n.USER_FIELD_LABEL,
    helpText: i18n.JIRA_SERVICE_MANAGEMENT_USER_HELP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'user',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.user,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })))));
};
AdditionalOptions.displayName = 'AdditionalOptions';
const CloseAlertComponent = ({
  editSubAction,
  editOptionalSubAction,
  errors,
  index,
  messageVariables,
  subActionParams,
  showSaveError
}) => {
  const isAliasInvalid = errors['subActionParams.alias'] !== undefined && Number(errors['subActionParams.alias'].length) > 0 && (subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.alias) !== undefined || showSaveError;
  const [showingMoreOptions, setShowingMoreOptions] = (0, _react.useState)(false);
  const toggleShowingMoreOptions = (0, _react.useCallback)(() => setShowingMoreOptions(previousState => !previousState), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "jsm-alias-row",
    fullWidth: true,
    error: errors['subActionParams.alias'],
    isInvalid: isAliasInvalid,
    label: i18n.ALIAS_FIELD_LABEL,
    helpText: i18n.JIRA_SERVICE_MANAGEMENT_ALIAS_HELP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'alias',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.alias,
    errors: errors['subActionParams.alias'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'note',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.note,
    label: i18n.NOTE_FIELD_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), showingMoreOptions ? /*#__PURE__*/_react.default.createElement(AdditionalOptions, {
    subActionParams: subActionParams,
    index: index,
    messageVariables: messageVariables,
    editOptionalSubAction: editOptionalSubAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_display_more_options.DisplayMoreOptions, {
    showingMoreOptions: showingMoreOptions,
    toggleShowingMoreOptions: toggleShowingMoreOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
};
CloseAlertComponent.displayName = 'CloseAlert';
const CloseAlert = exports.CloseAlert = /*#__PURE__*/_react.default.memo(CloseAlertComponent);