"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmailActionConnectorFields = void 0;
exports.nullableString = nullableString;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/actions-plugin/common");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common2 = require("../../../common");
var _email = require("./email");
var _use_email_config = require("./use_email_config");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/email/email_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const ExchangeFormFields = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./exchange_form'))));
const shouldDisableEmailConfiguration = service => (0, _lodash.isEmpty)(service) || service !== _common2.AdditionalEmailServices.EXCHANGE && service !== _common2.AdditionalEmailServices.OTHER;
const getEmailConfig = (href, validateFunc) => ({
  label: i18n.FROM_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.email.configureAccountsHelpLabel",
    defaultMessage: "Configure email accounts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  })),
  validations: [{
    validator: emptyField(i18n.SENDER_REQUIRED)
  }, {
    validator: ({
      value
    }) => {
      const validatedEmail = validateFunc([value], {
        isSender: true
      })[0];
      if (!validatedEmail.valid) {
        const message = validatedEmail.reason === _common.InvalidEmailReason.notAllowed ? i18n.getNotAllowedEmailAddress(value) : i18n.getInvalidEmailAddress(value);
        return {
          message
        };
      }
    }
  }]
});
const portConfig = {
  label: i18n.PORT_LABEL,
  validations: [{
    validator: emptyField(i18n.PORT_REQUIRED)
  }, {
    validator: ({
      value
    }) => {
      const port = Number.parseFloat(value);
      if (!Number.isInteger(port)) {
        return {
          message: i18n.PORT_INVALID
        };
      }
    }
  }]
};
const EmailActionConnectorFields = ({
  readOnly
}) => {
  const {
    docLinks,
    http,
    isCloud,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const {
    services: {
      validateEmailAddresses,
      enabledEmailServices
    }
  } = (0, _public.useConnectorContext)();
  const form = (0, _hook_form_lib.useFormContext)();
  const {
    updateFieldValues
  } = form;
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.service', 'config.hasAuth']
  });
  const emailFieldConfig = (0, _react.useMemo)(() => getEmailConfig(docLinks.links.alerting.emailActionConfig, validateEmailAddresses), [docLinks.links.alerting.emailActionConfig, validateEmailAddresses]);
  const {
    service = null,
    hasAuth = false
  } = config !== null && config !== void 0 ? config : {};
  const disableServiceConfig = shouldDisableEmailConfiguration(service);
  const {
    isLoading,
    getEmailServiceConfig
  } = (0, _use_email_config.useEmailConfig)({
    http,
    toasts
  });
  const initialService = (0, _react.useRef)(service);
  if (!initialService.current && service) {
    initialService.current = service;
  }
  const availableEmailServices = (0, _email.getEmailServices)(isCloud, enabledEmailServices, initialService.current);
  (0, _react.useEffect)(() => {
    async function fetchConfig() {
      if (service === null || service === _common2.AdditionalEmailServices.OTHER || service === _common2.AdditionalEmailServices.EXCHANGE) {
        return;
      }
      const emailConfig = await getEmailServiceConfig(service);
      updateFieldValues({
        config: {
          host: emailConfig === null || emailConfig === void 0 ? void 0 : emailConfig.host,
          port: emailConfig === null || emailConfig === void 0 ? void 0 : emailConfig.port,
          secure: emailConfig === null || emailConfig === void 0 ? void 0 : emailConfig.secure
        }
      });
    }
    fetchConfig();
  }, [updateFieldValues, getEmailServiceConfig, service]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.from",
    component: _components.TextField,
    config: emailFieldConfig,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailFromInput',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.service",
    component: _components.SelectField,
    config: {
      label: i18n.SERVICE_LABEL,
      validations: [{
        validator: emptyField(i18n.SERVICE_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailServiceSelectInput',
        options: availableEmailServices,
        fullWidth: true,
        hasNoInitialSelection: true,
        disabled: readOnly || isLoading,
        isLoading,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }))), service === _common2.AdditionalEmailServices.EXCHANGE ? /*#__PURE__*/_react.default.createElement(ExchangeFormFields, {
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.host",
    component: _components.TextField,
    config: {
      label: i18n.HOST_LABEL,
      validations: [{
        validator: emptyField(i18n.HOST_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailHostInput',
        readOnly,
        isLoading,
        disabled: disableServiceConfig
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.port",
    component: _components.NumericField,
    config: portConfig,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailPortInput',
        readOnly,
        isLoading,
        disabled: disableServiceConfig
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.secure",
    component: _components.ToggleField,
    config: {
      defaultValue: false
    },
    componentProps: {
      hasEmptyLabelSpace: true,
      euiFieldProps: {
        label: i18n.SECURE_LABEL,
        disabled: readOnly || disableServiceConfig,
        'data-test-subj': 'emailSecureSwitch',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.email.authenticationLabel",
    defaultMessage: "Authentication",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.hasAuth",
    component: _components.ToggleField,
    config: {
      defaultValue: true
    },
    componentProps: {
      euiFieldProps: {
        label: i18n.HAS_AUTH_LABEL,
        disabled: readOnly,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 15
    }
  }))), hasAuth ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.user",
    component: _components.TextField,
    config: {
      label: i18n.USERNAME_LABEL,
      validations: [{
        validator: emptyField(i18n.USERNAME_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailUserInput',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.password",
    config: {
      label: i18n.PASSWORD_LABEL,
      validations: [{
        validator: emptyField(i18n.PASSWORD_REQUIRED)
      }]
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'emailPasswordInput'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 19
    }
  })))) : null));
};

// if the string == null or is empty, return null, else return string
exports.default = exports.EmailActionConnectorFields = EmailActionConnectorFields;
function nullableString(str) {
  if (str == null || str.trim() === '') return null;
  return str;
}

// eslint-disable-next-line import/no-default-export