"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_URL_REQUIRED = exports.UPDATE_METHOD_REQUIRED = exports.UPDATE_INCIDENT_URL_HELP = exports.UPDATE_INCIDENT_URL = exports.UPDATE_INCIDENT_REQUIRED = exports.UPDATE_INCIDENT_METHOD = exports.UPDATE_INCIDENT_JSON_HELP = exports.UPDATE_INCIDENT_JSON = exports.SUMMARY_REQUIRED = exports.STEP_4B_DESCRIPTION = exports.STEP_4B = exports.STEP_4A_DESCRIPTION = exports.STEP_4A = exports.STEP_4 = exports.STEP_3_DESCRIPTION = exports.STEP_3 = exports.STEP_2_DESCRIPTION = exports.STEP_2 = exports.STEP_1 = exports.STATUS_OPEN = exports.STATUS_IN_PROGRESS = exports.STATUS_CLOSED = exports.SEVERITY_MEDIUM_LABEL = exports.SEVERITY_LOW_LABEL = exports.SEVERITY_HIGH_LABEL = exports.SEVERITY_CRITICAL_LABEL = exports.PREVIOUS = exports.NEXT = exports.MISSING_VARIABLES = exports.JSON = exports.HAS_AUTH = exports.GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED = exports.GET_METHOD_REQUIRED = exports.GET_INCIDENT_VIEW_URL_REQUIRED = exports.GET_INCIDENT_URL_REQUIRED = exports.GET_INCIDENT_URL_HELP = exports.GET_INCIDENT_URL = exports.GET_INCIDENT_TITLE_KEY_HELP = exports.GET_INCIDENT_TITLE_KEY = exports.GET_INCIDENT_REQUIRED = exports.GET_INCIDENT_METHOD = exports.GET_INCIDENT_JSON_HELP = exports.GET_INCIDENT_JSON = exports.EXTERNAL_TITLE_DESC = exports.EXTERNAL_INCIDENT_VIEW_URL_HELP = exports.EXTERNAL_INCIDENT_VIEW_URL = exports.EXTERNAL_ID_DESC = exports.DOC_LINK = exports.CREATE_URL_REQUIRED = exports.CREATE_RESPONSE_KEY_REQUIRED = exports.CREATE_METHOD_REQUIRED = exports.CREATE_INCIDENT_URL = exports.CREATE_INCIDENT_RESPONSE_KEY_HELP = exports.CREATE_INCIDENT_RESPONSE_KEY = exports.CREATE_INCIDENT_REQUIRED = exports.CREATE_INCIDENT_METHOD = exports.CREATE_INCIDENT_JSON_HELP = exports.CREATE_INCIDENT_JSON = exports.CREATE_COMMENT_URL_MISSING = exports.CREATE_COMMENT_URL_HELP = exports.CREATE_COMMENT_URL_FORMAT_REQUIRED = exports.CREATE_COMMENT_URL = exports.CREATE_COMMENT_METHOD_REQUIRED = exports.CREATE_COMMENT_METHOD = exports.CREATE_COMMENT_JSON_MISSING = exports.CREATE_COMMENT_JSON_HELP = exports.CREATE_COMMENT_JSON = exports.CREATE_COMMENT_FORMAT_MESSAGE = exports.CODE_EDITOR = exports.CASE_TITLE_DESC = exports.CASE_TAGS_DESC = exports.CASE_STATUS_DESC = exports.CASE_STATUS_ARIA_LABEL = exports.CASE_SEVERITY_DESC = exports.CASE_SEVERITY_ARIA_LABEL = exports.CASE_ID_DESC = exports.CASE_DESCRIPTION_DESC = exports.CASE_COMMENT_DESC = exports.ADD_CASES_VARIABLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_URL_REQUIRED = exports.CREATE_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateUrlText', {
  defaultMessage: 'Create case URL is required.'
});
const CREATE_INCIDENT_REQUIRED = exports.CREATE_INCIDENT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateIncidentText', {
  defaultMessage: 'Create case object is required and must be valid JSON.'
});
const CREATE_METHOD_REQUIRED = exports.CREATE_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateMethodText', {
  defaultMessage: 'Create case method is required.'
});
const CREATE_RESPONSE_KEY_REQUIRED = exports.CREATE_RESPONSE_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateIncidentResponseKeyText', {
  defaultMessage: 'Create case response case id key is required.'
});
const UPDATE_URL_REQUIRED = exports.UPDATE_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredUpdateUrlText', {
  defaultMessage: 'Update case URL is required.'
});
const UPDATE_INCIDENT_REQUIRED = exports.UPDATE_INCIDENT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredUpdateIncidentText', {
  defaultMessage: 'Update case object is required and must be valid JSON.'
});
const UPDATE_METHOD_REQUIRED = exports.UPDATE_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredUpdateMethodText', {
  defaultMessage: 'Update case method is required.'
});
const CREATE_COMMENT_URL_FORMAT_REQUIRED = exports.CREATE_COMMENT_URL_FORMAT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentUrlText', {
  defaultMessage: 'Create comment URL must be URL format.'
});
const CREATE_COMMENT_URL_MISSING = exports.CREATE_COMMENT_URL_MISSING = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentUrlMissing', {
  defaultMessage: 'Create comment URL is required.'
});
const CREATE_COMMENT_JSON_MISSING = exports.CREATE_COMMENT_JSON_MISSING = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentJsonMissing', {
  defaultMessage: 'Create comment Json is required.'
});
const CREATE_COMMENT_FORMAT_MESSAGE = exports.CREATE_COMMENT_FORMAT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentIncidentText', {
  defaultMessage: 'Create comment object must be valid JSON.'
});
const CREATE_COMMENT_METHOD_REQUIRED = exports.CREATE_COMMENT_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredCreateCommentMethodText', {
  defaultMessage: 'Create comment method is required.'
});
const GET_INCIDENT_URL_REQUIRED = exports.GET_INCIDENT_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentUrlText', {
  defaultMessage: 'Get case URL is required.'
});
const GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_TITLE_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentResponseExternalTitleKeyText', {
  defaultMessage: 'Get case response external case title key is required.'
});
const GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_CREATED_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentResponseCreatedKeyText', {
  defaultMessage: 'Get case response created date key is required.'
});
const GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED = exports.GET_RESPONSE_EXTERNAL_UPDATED_KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentResponseUpdatedKeyText', {
  defaultMessage: 'Get case response updated date key is required.'
});
const GET_INCIDENT_VIEW_URL_REQUIRED = exports.GET_INCIDENT_VIEW_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentViewUrlKeyText', {
  defaultMessage: 'View case URL is required.'
});
const MISSING_VARIABLES = variables => _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.missingVariables', {
  defaultMessage: 'Missing required {variableCount, plural, one {variable} other {variables}}: {variables}',
  values: {
    variableCount: variables.length,
    variables: variables.join(', ')
  }
});
exports.MISSING_VARIABLES = MISSING_VARIABLES;
const SUMMARY_REQUIRED = exports.SUMMARY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredWebhookSummaryText', {
  defaultMessage: 'Title is required.'
});
const CREATE_INCIDENT_METHOD = exports.CREATE_INCIDENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentMethodTextFieldLabel', {
  defaultMessage: 'Create case method'
});
const CREATE_INCIDENT_URL = exports.CREATE_INCIDENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentUrlTextFieldLabel', {
  defaultMessage: 'Create case URL'
});
const CREATE_INCIDENT_JSON = exports.CREATE_INCIDENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentJsonTextFieldLabel', {
  defaultMessage: 'Create case object'
});
const CREATE_INCIDENT_JSON_HELP = exports.CREATE_INCIDENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentJsonHelpText', {
  defaultMessage: 'JSON object to create a case. Use the variable selector to add cases data to the payload.'
});
const JSON = exports.JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.jsonFieldLabel', {
  defaultMessage: 'JSON'
});
const CODE_EDITOR = exports.CODE_EDITOR = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.jsonCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
const CREATE_INCIDENT_RESPONSE_KEY = exports.CREATE_INCIDENT_RESPONSE_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentResponseKeyTextFieldLabel', {
  defaultMessage: 'Create case response external key'
});
const CREATE_INCIDENT_RESPONSE_KEY_HELP = exports.CREATE_INCIDENT_RESPONSE_KEY_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createIncidentResponseKeyHelpText', {
  defaultMessage: 'JSON key in the create external case response that contains the case ID'
});
const ADD_CASES_VARIABLE = exports.ADD_CASES_VARIABLE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.addVariable', {
  defaultMessage: 'Add variable'
});
const GET_INCIDENT_METHOD = exports.GET_INCIDENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentMethodTextFieldLabel', {
  defaultMessage: 'Get case method'
});
const GET_INCIDENT_URL = exports.GET_INCIDENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentUrlTextFieldLabel', {
  defaultMessage: 'Get case URL'
});
const GET_METHOD_REQUIRED = exports.GET_METHOD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetMethodText', {
  defaultMessage: 'Get case method is required.'
});
const GET_INCIDENT_URL_HELP = exports.GET_INCIDENT_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentUrlHelp', {
  defaultMessage: 'API URL to get case details in JSON format from the external system. Use the variable selector to add the external system ID to the URL.'
});
const GET_INCIDENT_TITLE_KEY = exports.GET_INCIDENT_TITLE_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentResponseExternalTitleKeyTextFieldLabel', {
  defaultMessage: 'Get case response external title key'
});
const GET_INCIDENT_TITLE_KEY_HELP = exports.GET_INCIDENT_TITLE_KEY_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentResponseExternalTitleKeyHelp', {
  defaultMessage: 'JSON key in the get external case response that contains the case title'
});
const GET_INCIDENT_JSON_HELP = exports.GET_INCIDENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentJsonHelp', {
  defaultMessage: 'JSON object to get a case. Use the variable selector to add cases data to the payload.'
});
const GET_INCIDENT_JSON = exports.GET_INCIDENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.getIncidentJsonTextFieldLabel', {
  defaultMessage: 'Get case object'
});
const GET_INCIDENT_REQUIRED = exports.GET_INCIDENT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.error.requiredGetIncidentText', {
  defaultMessage: 'Get case object is required and must be valid JSON.'
});
const EXTERNAL_INCIDENT_VIEW_URL = exports.EXTERNAL_INCIDENT_VIEW_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.viewIncidentUrlTextFieldLabel', {
  defaultMessage: 'External case view URL'
});
const EXTERNAL_INCIDENT_VIEW_URL_HELP = exports.EXTERNAL_INCIDENT_VIEW_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.viewIncidentUrlHelp', {
  defaultMessage: 'URL to view a case in the external system. Use the variable selector to add external system ID or external system title to the URL.'
});
const UPDATE_INCIDENT_METHOD = exports.UPDATE_INCIDENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentMethodTextFieldLabel', {
  defaultMessage: 'Update case method'
});
const UPDATE_INCIDENT_URL = exports.UPDATE_INCIDENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentUrlTextFieldLabel', {
  defaultMessage: 'Update case URL'
});
const UPDATE_INCIDENT_URL_HELP = exports.UPDATE_INCIDENT_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentUrlHelp', {
  defaultMessage: 'API URL to update a case.'
});
const UPDATE_INCIDENT_JSON = exports.UPDATE_INCIDENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentJsonTextFieldLabel', {
  defaultMessage: 'Update case object'
});
const UPDATE_INCIDENT_JSON_HELP = exports.UPDATE_INCIDENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.updateIncidentJsonHelpl', {
  defaultMessage: 'JSON object to update a case. Use the variable selector to add cases data to the payload.'
});
const CREATE_COMMENT_METHOD = exports.CREATE_COMMENT_METHOD = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentMethodTextFieldLabel', {
  defaultMessage: 'Create comment method'
});
const CREATE_COMMENT_URL = exports.CREATE_COMMENT_URL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentUrlTextFieldLabel', {
  defaultMessage: 'Create comment URL'
});
const CREATE_COMMENT_URL_HELP = exports.CREATE_COMMENT_URL_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentUrlHelp', {
  defaultMessage: 'API URL to add a comment to a case.'
});
const CREATE_COMMENT_JSON = exports.CREATE_COMMENT_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentJsonTextFieldLabel', {
  defaultMessage: 'Create comment object'
});
const CREATE_COMMENT_JSON_HELP = exports.CREATE_COMMENT_JSON_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentJsonHelp', {
  defaultMessage: 'JSON object to create a comment. Use the variable selector to add cases data to the payload.'
});
const HAS_AUTH = exports.HAS_AUTH = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.hasAuthSwitchLabel', {
  defaultMessage: 'Require authentication for this webhook'
});
const STEP_1 = exports.STEP_1 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step1', {
  defaultMessage: 'Set up connector'
});
const STEP_2 = exports.STEP_2 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step2', {
  defaultMessage: 'Create case'
});
const STEP_2_DESCRIPTION = exports.STEP_2_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step2Description', {
  defaultMessage: 'Set fields to create a case in the external system. Check your service’s API documentation to understand what fields are required.'
});
const STEP_3 = exports.STEP_3 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step3', {
  defaultMessage: 'Get case information'
});
const STEP_3_DESCRIPTION = exports.STEP_3_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step3Description', {
  defaultMessage: 'Set fields to add comments to a case in the external system. For some systems, this may be the same method as creating updates in cases. Check your service’s API documentation to understand what fields are required.'
});
const STEP_4 = exports.STEP_4 = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4', {
  defaultMessage: 'Comments and updates'
});
const STEP_4A = exports.STEP_4A = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4a', {
  defaultMessage: 'Create update in case'
});
const STEP_4A_DESCRIPTION = exports.STEP_4A_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4aDescription', {
  defaultMessage: 'Set fields to update a case in the external system. For some systems, this may be the same method as adding comments to cases.'
});
const STEP_4B = exports.STEP_4B = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4b', {
  defaultMessage: 'Add comment in case'
});
const STEP_4B_DESCRIPTION = exports.STEP_4B_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.step4bDescription', {
  defaultMessage: 'Set fields to add comments to a case in the external system. For some systems, this may be the same method as creating updates in cases.'
});
const NEXT = exports.NEXT = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.next', {
  defaultMessage: 'Next'
});
const PREVIOUS = exports.PREVIOUS = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.previous', {
  defaultMessage: 'Previous'
});
const CASE_TITLE_DESC = exports.CASE_TITLE_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseTitleDesc', {
  defaultMessage: 'Kibana case title'
});
const CASE_DESCRIPTION_DESC = exports.CASE_DESCRIPTION_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseDescriptionDesc', {
  defaultMessage: 'Kibana case description'
});
const CASE_TAGS_DESC = exports.CASE_TAGS_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseTagsDesc', {
  defaultMessage: 'Kibana case tags'
});
const CASE_ID_DESC = exports.CASE_ID_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseIdDesc', {
  defaultMessage: 'Kibana case ID'
});
const CASE_SEVERITY_DESC = exports.CASE_SEVERITY_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseSeverityDesc', {
  defaultMessage: 'Kibana case severity'
});
const CASE_STATUS_DESC = exports.CASE_STATUS_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseStatusDesc', {
  defaultMessage: 'Kibana case status'
});
const CASE_COMMENT_DESC = exports.CASE_COMMENT_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.caseCommentDesc', {
  defaultMessage: 'Kibana case comment'
});
const EXTERNAL_ID_DESC = exports.EXTERNAL_ID_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.externalIdDesc', {
  defaultMessage: 'External system ID'
});
const EXTERNAL_TITLE_DESC = exports.EXTERNAL_TITLE_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.externalTitleDesc', {
  defaultMessage: 'External system title'
});
const DOC_LINK = exports.DOC_LINK = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.docLink', {
  defaultMessage: 'Configuring Webhook - Case Management connector.'
});
const SEVERITY_CRITICAL_LABEL = exports.SEVERITY_CRITICAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.criticalLabel', {
  defaultMessage: 'Critical'
});
const SEVERITY_HIGH_LABEL = exports.SEVERITY_HIGH_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.highLabel', {
  defaultMessage: 'High'
});
const SEVERITY_MEDIUM_LABEL = exports.SEVERITY_MEDIUM_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.mediumLabel', {
  defaultMessage: 'Medium'
});
const SEVERITY_LOW_LABEL = exports.SEVERITY_LOW_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.lowLabel', {
  defaultMessage: 'Low'
});
const STATUS_OPEN = exports.STATUS_OPEN = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.status.open', {
  defaultMessage: 'Open'
});
const STATUS_CLOSED = exports.STATUS_CLOSED = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.status.closed', {
  defaultMessage: 'Closed'
});
const STATUS_IN_PROGRESS = exports.STATUS_IN_PROGRESS = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.status.inProgress', {
  defaultMessage: 'In progress'
});
const CASE_STATUS_ARIA_LABEL = exports.CASE_STATUS_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.statusFilter.optionsAriaLabel', {
  defaultMessage: 'Case status'
});
const CASE_SEVERITY_ARIA_LABEL = exports.CASE_SEVERITY_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.severityFilter.optionsAriaLabel', {
  defaultMessage: 'Case severity'
});