"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOauth2DeleteTokenAxiosInterceptor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOauth2DeleteTokenAxiosInterceptor = ({
  connectorTokenClient,
  connectorId
}) => {
  return {
    onFulfilled: async response => {
      // Look for 4xx errors that indicate something is wrong with the request
      // We don't know for sure that it is an access token issue but remove saved
      // token just to be sure
      if (response.status >= 400 && response.status < 500) {
        await connectorTokenClient.deleteConnectorTokens({
          connectorId
        });
      }
      return response;
    },
    onRejected: async error => {
      var _error$response;
      const statusCode = (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status;

      // Look for 4xx errors that indicate something is wrong with the request
      // We don't know for sure that it is an access token issue but remove saved
      // token just to be sure
      if (statusCode && statusCode >= 400 && statusCode < 500) {
        await connectorTokenClient.deleteConnectorTokens({
          connectorId
        });
      }
      return Promise.reject(error);
    }
  };
};
exports.getOauth2DeleteTokenAxiosInterceptor = getOauth2DeleteTokenAxiosInterceptor;