"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryFormTypeChooser = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../types");
var _util = require("../util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/expression/query_form_type_chooser.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryFormTypeChooser = ({
  searchType,
  onFormTypeSelect
}) => {
  const {
    uiSettings
  } = (0, _util.useTriggerUiActionServices)();
  const isEsqlEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('enableESQL');
  const formTypeItems = (0, _react.useMemo)(() => {
    const items = [{
      formType: _types.SearchType.searchSource,
      label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.kqlOrLuceneFormTypeLabel', {
        defaultMessage: 'KQL or Lucene'
      }),
      description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.kqlOrLuceneFormTypeDescription', {
        defaultMessage: 'Use KQL or Lucene to define a text-based query.'
      })
    }, {
      formType: _types.SearchType.esQuery,
      label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.queryDslFormTypeLabel', {
        defaultMessage: 'Query DSL'
      }),
      description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.queryDslFormTypeDescription', {
        defaultMessage: 'Use the Elasticsearch Query DSL to define a query.'
      })
    }];
    if (isEsqlEnabled) {
      items.push({
        formType: _types.SearchType.esqlQuery,
        label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.esqlFormTypeLabel', {
          defaultMessage: 'ES|QL'
        }),
        description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.esqlFormTypeDescription', {
          defaultMessage: 'Use ES|QL to define a text-based query.'
        })
      });
    }
    return items;
  }, [isEsqlEnabled]);
  if (searchType) {
    const activeFormTypeItem = formTypeItems.find(item => item.formType === searchType);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      "data-test-subj": "selectedRuleFormTypeTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 19
      }
    }, activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.label))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "cross",
      color: "danger",
      "data-test-subj": "queryFormTypeChooserCancel",
      "aria-label": _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectQueryFormType.cancelSelectionAriaLabel', {
        defaultMessage: 'Cancel selection'
      }),
      onClick: () => onFormTypeSelect(null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      "data-test-subj": "selectedRuleFormTypeDescription",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, activeFormTypeItem === null || activeFormTypeItem === void 0 ? void 0 : activeFormTypeItem.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "queryFormTypeChooserTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.selectQueryFormTypeLabel",
    defaultMessage: "Select a query type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    gutterSize: "m",
    size: "m",
    maxWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, formTypeItems.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    wrapText: true,
    key: `form-type-${item.formType}`,
    "data-test-subj": `queryFormType_${item.formType}`,
    color: "primary",
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 21
      }
    }, item.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 19
      }
    }, item.description))),
    onClick: () => onFormTypeSelect(item.formType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }));
};
exports.QueryFormTypeChooser = QueryFormTypeChooser;