"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewSelectPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/components/data_view_select_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DESKTOP_WIDTH = 450;
const MOBILE_WIDTH = 350;
const toDataViewListItem = dataView => {
  return {
    id: dataView.id,
    title: dataView.title,
    name: dataView.name,
    type: dataView.type,
    isAdhoc: !dataView.isPersisted()
  };
};
const DataViewSelectPopover = ({
  dependencies: {
    dataViews,
    dataViewEditor
  },
  metadata,
  dataView,
  onSelectDataView,
  onChangeMetaData
}) => {
  var _dataView$getName;
  const [loadingDataViews, setLoadingDataViews] = (0, _react.useState)(false);
  const [dataViewItems, setDataViewsItems] = (0, _react.useState)([]);
  const [dataViewPopoverOpen, setDataViewPopoverOpen] = (0, _react.useState)(false);
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs']);
  const closeDataViewEditor = (0, _react.useRef)();
  const computedMetadata = (0, _react.useMemo)(() => {
    var _metadata$adHocDataVi, _metadata$isManagemen;
    return {
      ...metadata,
      adHocDataViewList: (_metadata$adHocDataVi = metadata === null || metadata === void 0 ? void 0 : metadata.adHocDataViewList) !== null && _metadata$adHocDataVi !== void 0 ? _metadata$adHocDataVi : [],
      isManagementPage: (_metadata$isManagemen = metadata === null || metadata === void 0 ? void 0 : metadata.isManagementPage) !== null && _metadata$isManagemen !== void 0 ? _metadata$isManagemen : true
    };
  }, [metadata]);
  const allDataViewItems = (0, _react.useMemo)(() => [...(dataViewItems !== null && dataViewItems !== void 0 ? dataViewItems : []), ...(computedMetadata.adHocDataViewList || []).map(toDataViewListItem)], [dataViewItems, computedMetadata.adHocDataViewList]);
  const closeDataViewPopover = (0, _react.useCallback)(() => setDataViewPopoverOpen(false), []);
  const onChangeDataView = (0, _react.useCallback)(async selectedDataViewId => {
    const selectedDataView = await dataViews.get(selectedDataViewId);
    onSelectDataView(selectedDataView);
    closeDataViewPopover();
  }, [closeDataViewPopover, dataViews, onSelectDataView]);
  const loadPersistedDataViews = (0, _react.useCallback)(async () => {
    setLoadingDataViews(true);
    try {
      // Calling getIds with refresh = true to make sure we don't get stale data
      const ids = await dataViews.getIds(true);
      const dataViewsList = await Promise.all(ids.map(id => dataViews.get(id)));
      setDataViewsItems(dataViewsList.map(toDataViewListItem));
    } catch (e) {
      // Error fetching data views
    }
    setLoadingDataViews(false);
  }, [dataViews]);
  const onAddAdHocDataView = (0, _react.useCallback)(adHocDataView => {
    onChangeMetaData({
      ...computedMetadata,
      adHocDataViewList: [...(computedMetadata.adHocDataViewList || []), adHocDataView]
    });
  }, [computedMetadata, onChangeMetaData]);
  const createDataView = (0, _react.useMemo)(() => dataViewEditor.userPermissions.editDataView() ? () => {
    closeDataViewEditor.current = dataViewEditor.openEditor({
      onSave: async createdDataView => {
        if (createdDataView.id) {
          if (!createdDataView.isPersisted()) {
            onAddAdHocDataView(createdDataView);
          }
          await loadPersistedDataViews();
          await onChangeDataView(createdDataView.id);
        }
      },
      allowAdHocDataView: true
    });
  } : undefined, [dataViewEditor, loadPersistedDataViews, onChangeDataView, onAddAdHocDataView]);
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editor when unmounting
      if (closeDataViewEditor.current) {
        closeDataViewEditor.current();
      }
    };
  }, []);
  (0, _react.useEffect)(() => {
    loadPersistedDataViews();
  }, [loadPersistedDataViews]);
  const createDataViewButtonPadding = (0, _eui.useEuiPaddingCSS)('left');
  const onCreateDefaultAdHocDataView = (0, _react.useCallback)(async dataViewSpec => {
    var _newDataView$fields$g;
    const newDataView = await dataViews.create(dataViewSpec);
    if (((_newDataView$fields$g = newDataView.fields.getByName('@timestamp')) === null || _newDataView$fields$g === void 0 ? void 0 : _newDataView$fields$g.type) === 'date') {
      newDataView.timeFieldName = '@timestamp';
    }
    onAddAdHocDataView(newDataView);
    onChangeDataView(newDataView.id);
  }, [dataViews, onAddAdHocDataView, onChangeDataView]);
  if (loadingDataViews) {
    // The loading indicator is to make sure we don't render an
    // empty popover when the DV cache is initially loading
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "dataViewPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      display: "columns",
      "data-test-subj": "selectDataViewExpression",
      description: _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewLabel', {
        defaultMessage: 'data view'
      }),
      value: (_dataView$getName = dataView === null || dataView === void 0 ? void 0 : dataView.getName()) !== null && _dataView$getName !== void 0 ? _dataView$getName : _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewPlaceholder', {
        defaultMessage: 'Select a data view'
      }),
      isActive: dataViewPopoverOpen,
      onClick: () => {
        setDataViewPopoverOpen(true);
      },
      isInvalid: !(dataView !== null && dataView !== void 0 && dataView.id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 9
      }
    }),
    isOpen: dataViewPopoverOpen,
    closePopover: closeDataViewPopover,
    ownFocus: true,
    anchorPosition: "downLeft",
    display: "block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          width: ${isMobile ? `${MOBILE_WIDTH}px` : `${DESKTOP_WIDTH}px`};
        `,
    "data-test-subj": "chooseDataViewPopoverContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewPopoverTitle', {
    defaultMessage: 'Data view'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "closeDataViewPopover",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.closeDataViewPopoverLabel', {
      defaultMessage: 'Close'
    }),
    onClick: closeDataViewPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_public.DataViewSelector, {
    currentDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    dataViewsList: allDataViewItems,
    setPopoverIsOpen: setDataViewPopoverOpen,
    onChangeDataView: onChangeDataView,
    onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }), createDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: createDataViewButtonPadding.s,
    iconType: "plusInCircleFilled",
    "data-test-subj": "chooseDataViewPopover.createDataViewButton",
    onClick: () => {
      closeDataViewPopover();
      createDataView();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.dataViewPopover.createDataViewButton', {
    defaultMessage: 'Create a data view'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.components.ui.alertParams.dataViewPopover.createDataViewButton.noPermissionDescription",
    defaultMessage: "You need additional privileges to create data views. Contact your administrator.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  })))));
};
exports.DataViewSelectPopover = DataViewSelectPopover;