"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderSpaceSelectorApp = exports.SpaceSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./space_selector.scss");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _full_screen_bg_css = require("@kbn/css-utils/public/full_screen_bg_css");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxAvatarSolution = require("@kbn/shared-ux-avatar-solution");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _uiTheme = require("@kbn/ui-theme");
var _components = require("./components");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/space_selector/space_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Number of spaces above which the selector defaults to table view for better scalability
const VIEW_MODE_THRESHOLD = 20;
class SpaceSelector extends _react2.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "headerRef", void 0);
    (0, _defineProperty2.default)(this, "customBrandingSubscription", void 0);
    (0, _defineProperty2.default)(this, "setHeaderRef", ref => {
      this.headerRef = ref;
      // forcing focus of header for screen readers to announce on page load
      if (this.headerRef) {
        this.headerRef.focus();
      }
    });
    (0, _defineProperty2.default)(this, "getSearchField", () => {
      if (!this.state.spaces || this.state.spaces.length < _constants.SPACE_SEARCH_COUNT_THRESHOLD) {
        return null;
      }
      const inputLabel = _i18n.i18n.translate('xpack.spaces.spaceSelector.findSpacePlaceholder', {
        defaultMessage: 'Find a space'
      });
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
        css: (0, _react.css)`
            width: ${_uiTheme.euiThemeVars.euiFormMaxWidth};
            max-width: 100%;
            margin-inline: auto;
          `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldSearch, {
        placeholder: inputLabel,
        "aria-label": inputLabel,
        incremental: true,
        onSearch: this.onSearch,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 269,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "onSearch", (searchTerm = '') => {
      this.setState({
        searchTerm: searchTerm.trim().toLowerCase()
      });
    });
    (0, _defineProperty2.default)(this, "onViewModeChange", viewMode => {
      this.setState({
        viewMode
      });
    });
    (0, _defineProperty2.default)(this, "getViewToggle", () => {
      const {
        viewMode
      } = this.state;
      const toggleOptions = [{
        id: 'grid',
        label: _i18n.i18n.translate('xpack.spaces.spaceSelector.gridViewLabel', {
          defaultMessage: 'Grid view'
        }),
        iconType: 'apps'
      }, {
        id: 'table',
        label: _i18n.i18n.translate('xpack.spaces.spaceSelector.tableViewLabel', {
          defaultMessage: 'Table view'
        }),
        iconType: 'list'
      }];
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
        css: (0, _react.css)`
          .euiButtonGroup__buttons .euiButtonGroupButton {
            min-width: 40px;
            width: 40px;
          }
        `,
        legend: _i18n.i18n.translate('xpack.spaces.spaceSelector.viewToggleLegend', {
          defaultMessage: 'View options'
        }),
        options: toggleOptions,
        idSelected: viewMode,
        onChange: id => this.onViewModeChange(id),
        buttonSize: "m",
        isIconOnly: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 305,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "getSearchAndToggle", () => {
      const {
        spaces
      } = this.state;

      // Show search field and toggle if we have enough spaces to warrant them
      const showSearchAndToggle = spaces && spaces.length >= _constants.SPACE_SEARCH_COUNT_THRESHOLD;
      if (!showSearchAndToggle) {
        return null;
      }
      const inputLabel = _i18n.i18n.translate('xpack.spaces.spaceSelector.findSpacePlaceholder', {
        defaultMessage: 'Find a space'
      });
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center",
        justifyContent: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 9
        }
      }, showSearchAndToggle && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 342,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement("div", {
        css: (0, _react.css)`
                  width: ${_uiTheme.euiThemeVars.euiFormMaxWidth};
                  max-width: 100%;
                `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldSearch, {
        placeholder: inputLabel,
        "aria-label": inputLabel,
        incremental: true,
        onSearch: this.onSearch,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 17
        }
      }))), showSearchAndToggle && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 35
        }
      }, this.getViewToggle())), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 9
        }
      }));
    });
    this.state = {
      loading: false,
      searchTerm: '',
      spaces: [],
      viewMode: 'grid'
    };
  }
  componentDidMount() {
    if (this.state.spaces.length === 0) {
      this.loadSpaces();
    }
    this.customBrandingSubscription = this.props.customBranding$.subscribe(next => {
      this.setState({
        ...this.state,
        customLogo: next.logo
      });
    });
  }
  componentWillUnmount() {
    var _this$customBrandingS;
    (_this$customBrandingS = this.customBrandingSubscription) === null || _this$customBrandingS === void 0 ? void 0 : _this$customBrandingS.unsubscribe();
  }
  loadSpaces() {
    this.setState({
      loading: true
    });
    const {
      spacesManager
    } = this.props;
    spacesManager.getSpaces().then(spaces => {
      this.setState({
        loading: false,
        spaces,
        viewMode: spaces.length > VIEW_MODE_THRESHOLD ? 'table' : 'grid'
      });
    }).catch(err => {
      this.setState({
        loading: false,
        error: err
      });
    });
  }
  render() {
    const {
      spaces,
      searchTerm
    } = this.state;
    const panelStyles = (0, _react.css)`
      text-align: center;
      margin-inline: auto;
      max-width: 700px;
    `;
    let filteredSpaces = spaces;
    if (searchTerm) {
      filteredSpaces = spaces.filter(space => space.name.toLowerCase().indexOf(searchTerm) >= 0 || (space.description || '').toLowerCase().indexOf(searchTerm) >= 0);
    }
    return /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
      css: (0, _react.css)`
          background-color: transparent;
        `,
      "data-test-subj": "kibanaSpaceSelector",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(BackgroundPortal, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      color: "transparent",
      paddingSize: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      textAlign: "center",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    }), this.state.customLogo ? /*#__PURE__*/_react2.default.createElement(_eui.EuiImage, {
      src: this.state.customLogo,
      size: 64,
      alt: _i18n.i18n.translate('xpack.spaces.spaceSelector.customLogoAlt', {
        defaultMessage: 'Custom logo'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react2.default.createElement(_sharedUxAvatarSolution.KibanaSolutionAvatar, {
      name: "Elastic",
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", {
      css: (0, _react.css)`
                  &:focus {
                    outline: none;
                    text-decoration: underline;
                  }
                `,
      tabIndex: -1,
      ref: this.setHeaderRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.selectSpacesTitle",
      defaultMessage: "Select your space",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react2.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.changeSpaceAnytimeAvailabilityText",
      defaultMessage: "You can change your space at anytime.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }), this.getSearchAndToggle(), this.state.loading && /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 34
      }
    }), !this.state.loading && (this.state.viewMode === 'grid' ? /*#__PURE__*/_react2.default.createElement(_components.SpaceCards, {
      spaces: filteredSpaces,
      serverBasePath: this.props.serverBasePath,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react2.default.createElement(_components.SpaceTable, {
      spaces: filteredSpaces,
      serverBasePath: this.props.serverBasePath,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 15
      }
    })), !this.state.loading && !this.state.error && filteredSpaces.length === 0 && /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      css: panelStyles,
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.spaces.spaceSelector.noSpacesMatchSearchCriteriaDescription', {
      defaultMessage: 'No spaces match {searchTerm}',
      values: {
        searchTerm: `"${this.state.searchTerm}"`
      }
    }))))), !this.state.loading && this.state.error && /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      css: panelStyles,
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.errorLoadingSpacesDescription",
      defaultMessage: "Error loading spaces ({message})",
      values: {
        message: this.state.error.message
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react2.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.contactSysAdminDescription",
      defaultMessage: "Contact your system administrator.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 21
      }
    })))))));
  }
}
exports.SpaceSelector = SpaceSelector;
const renderSpaceSelectorApp = (services, {
  element
}, props) => {
  _reactDom.default.render(services.rendering.addContext(/*#__PURE__*/_react2.default.createElement(SpaceSelector, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 49
    }
  }))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
};

// portal the fixed background graphic so it doesn't affect page positioning or overlap on top of global banners
exports.renderSpaceSelectorApp = renderSpaceSelectorApp;
const BackgroundPortal = /*#__PURE__*/_react2.default.memo(function BackgroundPortal() {
  const kbnFullScreenBgCss = (0, _full_screen_bg_css.useKbnFullScreenBgCss)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    className: "spcSelectorBackground spcSelectorBackground__nonMixinAttributes",
    css: kbnFullScreenBgCss,
    role: "presentation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 7
    }
  }));
});