"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyStatusIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/copy_status_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CopyStatusIndicator = props => {
  const {
    summarizedCopyResult,
    conflictResolutionInProgress,
    pendingObjectRetry
  } = props;
  if (summarizedCopyResult.processing || conflictResolutionInProgress) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  }
  const objectResult = summarizedCopyResult.objects.find(o => o.type === props.object.type && o.id === props.object.id);
  const {
    conflict,
    hasMissingReferences,
    hasUnresolvableErrors,
    overwrite
  } = objectResult;
  const hasConflicts = conflict && !(pendingObjectRetry !== null && pendingObjectRetry !== void 0 && pendingObjectRetry.overwrite);
  const successful = !hasMissingReferences && !hasUnresolvableErrors && !hasConflicts;
  if (successful && !pendingObjectRetry) {
    // there is no retry pending, so this object was actually copied
    const message = overwrite ?
    /*#__PURE__*/
    // the object was overwritten
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.successAutomaticOverwriteMessage",
      defaultMessage: "Object was overwritten.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }) :
    /*#__PURE__*/
    // the object was not overwritten
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.successMessage",
      defaultMessage: "Object was copied.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'checkInCircleFilled',
      color: 'success',
      content: message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 12
      }
    });
  }
  if (successful && pendingObjectRetry) {
    const message = overwrite ?
    /*#__PURE__*/
    // this is an "automatic overwrite", e.g., the "Overwrite all conflicts" option was selected
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.pendingAutomaticOverwriteMessage",
      defaultMessage: "Object will be overwritten.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }) : pendingObjectRetry !== null && pendingObjectRetry !== void 0 && pendingObjectRetry.overwrite ?
    /*#__PURE__*/
    // this is a manual overwrite, e.g., the individual "Overwrite?" switch was enabled
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.pendingOverwriteMessage",
      defaultMessage: "Object will be overwritten. Disable 'Overwrite' to skip.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }) :
    /*#__PURE__*/
    // this object is pending success, but it will not result in an overwrite
    _react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.pendingMessage",
      defaultMessage: "Object will be copied.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'check',
      color: 'warning',
      content: message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 12
      }
    });
  }
  if (hasUnresolvableErrors) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: 'alert',
      color: 'danger',
      "data-test-subj": `cts-object-result-error-${objectResult.id}`,
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.copyToSpace.copyStatus.unresolvableErrorMessage",
        defaultMessage: "An error occurred copying this object.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    });
  }
  if (hasConflicts) {
    switch (conflict.error.type) {
      case 'conflict':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: 'alert',
          color: 'warning',
          content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 101,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.spaces.management.copyToSpace.copyStatus.conflictMessage",
            defaultMessage: "This conflicts with an existing object. Enable \u2018Overwrite\u2019 to replace it.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 102,
              columnNumber: 17
            }
          })),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 11
          }
        });
      case 'ambiguous_conflict':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: 'alert',
          color: 'warning',
          content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 116,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.spaces.management.copyToSpace.copyStatus.ambiguousConflictMessage",
            defaultMessage: "This conflicts with multiple existing objects. Enable \u2018Overwrite\u2019 to replace one.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 117,
              columnNumber: 17
            }
          })),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 11
          }
        });
    }
  }
  return hasMissingReferences ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: 'link',
    color: 'warning',
    "data-test-subj": `cts-object-result-missing-references-${objectResult.id}`,
    content: overwrite ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.missingReferencesAutomaticOverwriteMessage",
      defaultMessage: "Object will be overwritten, but one or more references are missing.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }) : conflict ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.missingReferencesOverwriteMessage",
      defaultMessage: "Object will be overwritten, but one or more references are missing. Disable 'Overwrite' to skip.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.copyStatus.missingReferencesMessage",
      defaultMessage: "Object will be copied, but one or more references are missing.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }) : null;
};
exports.CopyStatusIndicator = CopyStatusIndicator;