"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TextService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {});
    (0, _defineProperty2.default)(this, "i18n", void 0);
    (0, _defineProperty2.default)(this, "repositoryTypeNames", {});
  }
  setup(i18n) {
    this.i18n = i18n;
    this.repositoryTypeNames = {
      [_constants.REPOSITORY_TYPES.fs]: i18n.translate('xpack.snapshotRestore.repositoryType.fileSystemTypeName', {
        defaultMessage: 'Shared file system'
      }),
      [_constants.REPOSITORY_TYPES.url]: i18n.translate('xpack.snapshotRestore.repositoryType.readonlyTypeName', {
        defaultMessage: 'Read-only URL'
      }),
      [_constants.REPOSITORY_TYPES.s3]: i18n.translate('xpack.snapshotRestore.repositoryType.s3TypeName', {
        defaultMessage: 'AWS S3'
      }),
      [_constants.REPOSITORY_TYPES.hdfs]: i18n.translate('xpack.snapshotRestore.repositoryType.hdfsTypeName', {
        defaultMessage: 'Hadoop HDFS'
      }),
      [_constants.REPOSITORY_TYPES.azure]: i18n.translate('xpack.snapshotRestore.repositoryType.azureTypeName', {
        defaultMessage: 'Azure'
      }),
      [_constants.REPOSITORY_TYPES.gcs]: i18n.translate('xpack.snapshotRestore.repositoryType.gcsTypeName', {
        defaultMessage: 'Google Cloud Storage'
      }),
      [_constants.REPOSITORY_TYPES.source]: i18n.translate('xpack.snapshotRestore.repositoryType.sourceTypeName', {
        defaultMessage: 'Source-only'
      })
    };
    this.breadcrumbs = {
      home: i18n.translate('xpack.snapshotRestore.home.breadcrumbTitle', {
        defaultMessage: 'Snapshot and Restore'
      }),
      snapshots: i18n.translate('xpack.snapshotRestore.snapshots.breadcrumbTitle', {
        defaultMessage: 'Snapshots'
      }),
      repositories: i18n.translate('xpack.snapshotRestore.repositories.breadcrumbTitle', {
        defaultMessage: 'Repositories'
      }),
      policies: i18n.translate('xpack.snapshotRestore.policies.breadcrumbTitle', {
        defaultMessage: 'Policies'
      }),
      restore_status: i18n.translate('xpack.snapshotRestore.restoreStatus.breadcrumbTitle', {
        defaultMessage: 'Restore Status'
      }),
      repositoryAdd: i18n.translate('xpack.snapshotRestore.addRepository.breadcrumbTitle', {
        defaultMessage: 'Add repository'
      }),
      repositoryEdit: i18n.translate('xpack.snapshotRestore.editRepository.breadcrumbTitle', {
        defaultMessage: 'Edit repository'
      }),
      restoreSnapshot: i18n.translate('xpack.snapshotRestore.restoreSnapshot.breadcrumbTitle', {
        defaultMessage: 'Restore snapshot'
      }),
      policyAdd: i18n.translate('xpack.snapshotRestore.addPolicy.breadcrumbTitle', {
        defaultMessage: 'Add policy'
      }),
      policyEdit: i18n.translate('xpack.snapshotRestore.editPolicy.breadcrumbTitle', {
        defaultMessage: 'Edit policy'
      })
    };
  }
  getRepositoryTypeName(type, delegateType) {
    const getTypeName = repositoryType => {
      return this.repositoryTypeNames[repositoryType] || type || '';
    };
    if (type === _constants.REPOSITORY_TYPES.source && delegateType) {
      return this.i18n.translate('xpack.snapshotRestore.repositoryType.sourceTypeWithDelegateName', {
        defaultMessage: '{delegateType} (Source-only)',
        values: {
          delegateType: getTypeName(delegateType)
        }
      });
    }
    return getTypeName(type);
  }
  getTimeUnitLabel(timeUnit, timeValue) {
    switch (timeUnit) {
      case _constants.TIME_UNITS.SECOND:
        return this.i18n.translate('xpack.snapshotRestore.policyForm.timeUnits.secondLabel', {
          defaultMessage: '{timeValue, plural, one {second} other {seconds}}',
          values: {
            timeValue
          }
        });
      case _constants.TIME_UNITS.MINUTE:
        return this.i18n.translate('xpack.snapshotRestore.policyForm.timeUnits.minuteLabel', {
          defaultMessage: '{timeValue, plural, one {minute} other {minutes}}',
          values: {
            timeValue
          }
        });
      case _constants.TIME_UNITS.HOUR:
        return this.i18n.translate('xpack.snapshotRestore.policyForm.timeUnits.hourLabel', {
          defaultMessage: '{timeValue, plural, one {hour} other {hours}}',
          values: {
            timeValue
          }
        });
      case _constants.TIME_UNITS.DAY:
        return this.i18n.translate('xpack.snapshotRestore.policyForm.timeUnits.dayLabel', {
          defaultMessage: '{timeValue, plural, one {day} other {days}}',
          values: {
            timeValue
          }
        });
    }
  }
}
const textService = exports.textService = new TextService();