"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _http = require("../services/http");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/snapshot_delete_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SnapshotDeleteProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [snapshotIds, setSnapshotIds] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const deleteSnapshotPrompt = (ids, onSuccess = () => undefined) => {
    if (!ids || !ids.length) {
      throw new Error('No snapshot IDs specified for deletion');
    }
    setIsModalOpen(true);
    setSnapshotIds(ids);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
    setSnapshotIds([]);
  };
  const deleteSnapshot = () => {
    const snapshotsToDelete = [...snapshotIds];
    setIsDeleting(true);
    (0, _http.deleteSnapshots)(snapshotsToDelete).then(({
      data,
      error
    }) => {
      const {
        itemsDeleted,
        errors
      } = data || {
        itemsDeleted: undefined,
        errors: undefined
      };

      // Wait until request is done to close modal; deleting snapshots take longer due to their sequential nature
      closeModal();
      setIsDeleting(false);

      // Surface success notifications
      if (itemsDeleted && itemsDeleted.length) {
        const hasMultipleSuccesses = itemsDeleted.length > 1;
        const successMessage = hasMultipleSuccesses ? i18n.translate('xpack.snapshotRestore.deleteSnapshot.successMultipleNotificationTitle', {
          defaultMessage: 'Deleted {count} snapshots',
          values: {
            count: itemsDeleted.length
          }
        }) : i18n.translate('xpack.snapshotRestore.deleteSnapshot.successSingleNotificationTitle', {
          defaultMessage: "Deleted snapshot ''{name}''",
          values: {
            name: itemsDeleted[0].snapshot
          }
        });
        toastNotifications.addSuccess(successMessage);
        if (onSuccessCallback.current) {
          onSuccessCallback.current([...itemsDeleted]);
        }
      }

      // Surface error notifications
      // `error` is generic server error
      // `data.errors` are specific errors with removing particular snapshot(s)
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && snapshotsToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? i18n.translate('xpack.snapshotRestore.deleteSnapshot.errorMultipleNotificationTitle', {
          defaultMessage: 'Error deleting {count} snapshots',
          values: {
            count: errors && errors.length || snapshotsToDelete.length
          }
        }) : i18n.translate('xpack.snapshotRestore.deleteSnapshot.errorSingleNotificationTitle', {
          defaultMessage: "Error deleting snapshot ''{name}''",
          values: {
            name: errors && errors[0].id.snapshot || snapshotsToDelete[0].snapshot
          }
        });
        toastNotifications.addDanger(errorMessage);
      }
    });
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    const isSingle = snapshotIds.length === 1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": modalTitleId,
      title: isSingle ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteSingleTitle",
        defaultMessage: "Delete snapshot ''{name}''?",
        values: {
          name: snapshotIds[0].snapshot
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteMultipleTitle",
        defaultMessage: "Delete {count} snapshots?",
        values: {
          count: snapshotIds.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      }),
      titleProps: {
        id: modalTitleId
      },
      onCancel: closeModal,
      onConfirm: deleteSnapshot,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.confirmButtonLabel",
        defaultMessage: "Delete {count, plural, one {snapshot} other {snapshots}}",
        values: {
          count: snapshotIds.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 11
        }
      }),
      confirmButtonDisabled: isDeleting,
      buttonColor: "danger",
      "data-test-subj": "srdeleteSnapshotConfirmationModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, !isSingle ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteMultipleListDescription",
      defaultMessage: "You are about to delete these snapshots:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, snapshotIds.map(({
      snapshot,
      repository
    }) => /*#__PURE__*/_react.default.createElement("li", {
      key: `${repository}/${snapshot}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 17
      }
    }, snapshot)))) : null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteMultipleDescription",
      defaultMessage: "Restore operations associated with {count, plural, one {this snapshot} other {these snapshots}} will stop.",
      values: {
        count: snapshotIds.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    })), !isSingle && isDeleting ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 23
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.deletingCalloutTitle",
        defaultMessage: "Deleting snapshots",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 23
        }
      })))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deleteSnapshot.confirmModal.deletingCalloutDescription",
      defaultMessage: "This may take a few minutes.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 17
      }
    })))) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 5
    }
  }, children(deleteSnapshotPrompt), renderModal());
};
exports.SnapshotDeleteProvider = SnapshotDeleteProvider;