"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toMomentUnitOfTime = exports.toDurationUnit = exports.DurationUnit = exports.Duration = void 0;
var _std = require("@kbn/std");
var moment = _interopRequireWildcard(require("moment"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var DurationUnit = exports.DurationUnit = /*#__PURE__*/function (DurationUnit) {
  DurationUnit["Minute"] = "m";
  DurationUnit["Hour"] = "h";
  DurationUnit["Day"] = "d";
  DurationUnit["Week"] = "w";
  DurationUnit["Month"] = "M";
  return DurationUnit;
}(DurationUnit || {});
class Duration {
  constructor(value, unit) {
    this.value = value;
    this.unit = unit;
    if (isNaN(value) || value <= 0) {
      throw new Error('invalid duration value');
    }
    if (!Object.values(DurationUnit).includes(unit)) {
      throw new Error('invalid duration unit');
    }
  }
  add(other) {
    const currentDurationMoment = moment.duration(this.value, toMomentUnitOfTime(this.unit));
    const otherDurationMoment = moment.duration(other.value, toMomentUnitOfTime(other.unit));
    return new Duration(currentDurationMoment.add(otherDurationMoment).asMinutes(), DurationUnit.Minute);
  }
  isShorterThan(other) {
    const otherDurationMoment = moment.duration(other.value, toMomentUnitOfTime(other.unit));
    const currentDurationMoment = moment.duration(this.value, toMomentUnitOfTime(this.unit));
    return currentDurationMoment.asSeconds() < otherDurationMoment.asSeconds();
  }
  isLongerOrEqualThan(other) {
    return !this.isShorterThan(other);
  }
  isEqual(other) {
    return this.value === other.value && this.unit === other.unit;
  }
  format() {
    return `${this.value}${this.unit}`;
  }
  asSeconds() {
    return moment.duration(this.value, toMomentUnitOfTime(this.unit)).asSeconds();
  }
  asMinutes() {
    return moment.duration(this.value, toMomentUnitOfTime(this.unit)).asMinutes();
  }
}
exports.Duration = Duration;
const toDurationUnit = unit => {
  switch (unit) {
    case 'm':
      return DurationUnit.Minute;
    case 'h':
      return DurationUnit.Hour;
    case 'd':
      return DurationUnit.Day;
    case 'w':
      return DurationUnit.Week;
    case 'M':
      return DurationUnit.Month;
    default:
      throw new Error('invalid duration unit');
  }
};
exports.toDurationUnit = toDurationUnit;
const toMomentUnitOfTime = unit => {
  switch (unit) {
    case DurationUnit.Minute:
      return 'minutes';
    case DurationUnit.Hour:
      return 'hours';
    case DurationUnit.Day:
      return 'days';
    case DurationUnit.Week:
      return 'weeks';
    case DurationUnit.Month:
      return 'months';
    default:
      (0, _std.assertNever)(unit);
  }
};
exports.toMomentUnitOfTime = toMomentUnitOfTime;