"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toDateRange = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _std = require("@kbn/std");
var _moment = _interopRequireDefault(require("moment"));
var _time_window = require("../models/time_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toDateRange = (timeWindow, currentDate = new Date()) => {
  if (_sloSchema.calendarAlignedTimeWindowSchema.is(timeWindow)) {
    const unit = (0, _time_window.toCalendarAlignedTimeWindowMomentUnit)(timeWindow);
    const from = _moment.default.utc(currentDate).startOf(unit);
    const to = _moment.default.utc(currentDate).endOf(unit);
    return {
      from: from.toDate(),
      to: to.toDate()
    };
  }
  if (_sloSchema.rollingTimeWindowSchema.is(timeWindow)) {
    const unit = (0, _time_window.toRollingTimeWindowMomentUnit)(timeWindow);
    const now = _moment.default.utc(currentDate).startOf('minute');
    const from = now.clone().subtract(timeWindow.duration.value, unit);
    const to = now.clone();
    return {
      from: from.toDate(),
      to: to.toDate()
    };
  }
  (0, _std.assertNever)(timeWindow);
};
exports.toDateRange = toDateRange;