"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListItem = SloListItem;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_slo_list_actions = require("../../hooks/use_slo_list_actions");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _slo_badges = require("../badges/slo_badges");
var _burn_rate_rule_flyout = require("../common/burn_rate_rule_flyout");
var _edit_burn_rate_rule_flyout = require("../common/edit_burn_rate_rule_flyout");
var _slo_groupings = require("../common/slo_groupings");
var _slo_item_actions = require("../slo_item_actions");
var _slo_summary = require("../slo_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slo_list_view/slo_list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloListItem({
  slo,
  rules,
  refetchRules,
  historicalSummary = [],
  historicalSummaryLoading,
  activeAlerts
}) {
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isEditRuleFlyoutOpen, setIsEditRuleFlyoutOpen] = (0, _react.useState)(false);
  const {
    sloDetailsUrl
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  const {
    handleCreateRule
  } = (0, _use_slo_list_actions.useSloListActions)({
    slo,
    setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "sloItem",
    hasBorder: true,
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("a", {
    "data-test-subj": "o11ySloListItemLink",
    href: sloDetailsUrl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 23
    }
  }, slo.name), /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_slo_badges.SloBadges, {
    activeAlerts: activeAlerts,
    isLoading: !slo.summary,
    rules: rules,
    slo: slo,
    onClickRuleBadge: handleCreateRule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_summary.SloSummary, {
    slo: slo,
    historicalSummary: historicalSummary,
    historicalSummaryLoading: historicalSummaryLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_item_actions.SloItemActions, {
    slo: slo,
    rules: rules,
    isActionsPopoverOpen: isActionsPopoverOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    setIsActionsPopoverOpen: setIsActionsPopoverOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_edit_burn_rate_rule_flyout.EditBurnRateRuleFlyout, {
    rule: rules === null || rules === void 0 ? void 0 : rules[0],
    isEditRuleFlyoutOpen: isEditRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    refetchRules: refetchRules,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
}