"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthCallout = HealthCallout;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_slo_health = require("../../../../hooks/use_fetch_slo_health");
var _content_with_inspect_cta = require("../../../slo_details/components/health_callout/content_with_inspect_cta");
var _paths = require("../../../../../common/locators/paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/health_callout/health_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CALLOUT_SESSION_STORAGE_KEY = 'slo_health_callout_hidden';
function HealthCallout({
  sloList = []
}) {
  const {
    isLoading,
    isError,
    data: results
  } = (0, _use_fetch_slo_health.useFetchSloHealth)({
    list: sloList
  });
  const [showCallOut, setShowCallOut] = (0, _react.useState)(!sessionStorage.getItem(CALLOUT_SESSION_STORAGE_KEY));
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  if (!showCallOut) {
    return null;
  }
  if (isLoading || isError || results === undefined || (results === null || results === void 0 ? void 0 : results.length) === 0) {
    return null;
  }
  const unhealthyAndMissingSloList = results.filter(result => result.health.overall === 'unhealthy' || result.health.overall === 'missing');
  if (unhealthyAndMissingSloList.length === 0) {
    return null;
  }
  const dismiss = () => {
    setShowCallOut(false);
    sessionStorage.setItem('slo_health_callout_hidden', 'true');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "sloHealthCallout",
    color: "danger",
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    size: "s",
    onClick: e => {
      setIsOpen(!isOpen);
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.sloList.healthCallout.title",
      defaultMessage: "Some SLOs are unhealthy",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    alignItems: "flexStart",
    onClick: e => {
      e.stopPropagation();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sloHealthCalloutDescription",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.description",
    defaultMessage: "The following {count, plural, one {SLO is} other {SLOs are}} in an unhealthy state. Data may be missing or incomplete. You can inspect {count, plural, one {it} other {each one}} here:",
    values: {
      count: unhealthyAndMissingSloList.length
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, unhealthyAndMissingSloList.map(result => /*#__PURE__*/_react.default.createElement("li", {
    key: result.sloId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_content_with_inspect_cta.ContentWithInspectCta, {
    textSize: "xs",
    content: result.sloName,
    url: _paths.paths.sloDetails(result.sloId, '*', undefined, 'overview'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloHealthCalloutDimissButton",
    color: "text",
    size: "s",
    onClick: dismiss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.buttonDimissLabel",
    defaultMessage: "Dismiss",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 17
    }
  }))))));
}