"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditBurnRateRuleFlyout = EditBurnRateRuleFlyout;
var _react = _interopRequireDefault(require("react"));
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/common/edit_burn_rate_rule_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EditBurnRateRuleFlyout({
  refetchRules,
  rule,
  isEditRuleFlyoutOpen,
  setIsEditRuleFlyoutOpen
}) {
  const {
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    },
    ...plugins
  } = (0, _use_kibana.useKibana)().services;
  const handleSavedRule = async () => {
    refetchRules();
    setIsEditRuleFlyoutOpen(false);
  };
  const handleCloseRuleFlyout = async () => {
    setIsEditRuleFlyoutOpen(false);
  };
  return isEditRuleFlyoutOpen && rule ? /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...plugins,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    id: rule.id,
    onSubmit: handleSavedRule,
    onCancel: handleCloseRuleFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }) : null;
}