"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListCardView = SloListCardView;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_fetch_active_alerts = require("../../../../hooks/use_fetch_active_alerts");
var _use_fetch_historical_summary = require("../../../../hooks/use_fetch_historical_summary");
var _use_fetch_rules_for_slo = require("../../../../hooks/use_fetch_rules_for_slo");
var _slo_card_item = require("./slo_card_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/card_view/slo_list_card_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useColumns = () => {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isMedium = (0, _eui.useIsWithinBreakpoints)(['m']);
  const isXLarge = (0, _eui.useIsWithinBreakpoints)(['xl']);
  switch (true) {
    case isMobile:
      return 1;
    case isMedium:
      return 3;
    case isXLarge:
      return 4;
    default:
      return 3;
  }
};
function SloListCardView({
  sloList,
  loading,
  error
}) {
  const sloIdsAndInstanceIds = sloList.map(slo => [slo.id, slo.instanceId]);
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds
  });
  const {
    data: rulesBySlo,
    refetchRules
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloIdsAndInstanceIds.map(item => item[0])
  });
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList
  });
  const columns = useColumns();
  if (loading && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(LoadingSloGrid, {
      gridSize: columns,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: columns,
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, sloList.filter(slo => slo.summary).map(slo => {
    var _historicalSummaries$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${slo.id}-${slo.instanceId}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_slo_card_item.SloCardItem, {
      slo: slo,
      loading: loading,
      error: error,
      activeAlerts: activeAlertsBySlo.get(slo),
      rules: rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id],
      historicalSummary: (_historicalSummaries$ = historicalSummaries.find(historicalSummary => historicalSummary.sloId === slo.id && historicalSummary.instanceId === slo.instanceId)) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data,
      historicalSummaryLoading: historicalSummaryLoading,
      refetchRules: refetchRules,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }));
  }));
}
function LoadingSloGrid({
  gridSize
}) {
  const ROWS = 4;
  const COLUMNS = gridSize;
  const loaders = Array(ROWS * COLUMNS).fill(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: COLUMNS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, loaders.map((_, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      height: '200px'
    },
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  })), ' '))));
}