"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePurgeRollupData = usePurgeRollupData;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePurgeRollupData({
  name,
  onConfirm
}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  return (0, _reactQuery.useMutation)(['purgeRollupData'], ({
    purgePolicy,
    force,
    list
  }) => {
    return sloClient.fetch('POST /api/observability/slos/_bulk_purge_rollup 2023-10-31', {
      params: {
        body: {
          purgePolicy,
          force,
          list
        }
      }
    });
  }, {
    onError: error => {
      var _error$body$message, _error$body;
      let errorMessage = (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message;
      if (errorMessage.includes('At least one SLO')) {
        errorMessage = _i18n.i18n.translate('xpack.slo.purge.requestErrorNotification', {
          defaultMessage: 'The provided purge policy is invalid. {name} has a time window that is longer than the provided purge policy.',
          values: {
            name
          }
        });
      }
      toasts.addError(new Error(errorMessage), {
        title: _i18n.i18n.translate('xpack.slo.purge.errorNotification', {
          defaultMessage: 'Failed to schedule purge of rollup data for {name}',
          values: {
            name
          }
        })
      });
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.purge.successNotification', {
        defaultMessage: 'Purge of rollup data scheduled for {name}',
        values: {
          name
        }
      }));
      onConfirm === null || onConfirm === void 0 ? void 0 : onConfirm();
    }
  });
}