"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloHealthCallout = SloHealthCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/deeplinks-management/constants");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _use_kibana = require("../../../hooks/use_kibana");
var _use_fetch_slo_health = require("../../../hooks/use_fetch_slo_health");
var _action_modal = require("../../../context/action_modal");
var _slo_health_helpers = require("../../../lib/slo_health_helpers");
var _constants2 = require("../../../../common/constants");
var _content_with_reset_cta = require("./health_callout/content_with_reset_cta");
var _content_with_inspect_cta = require("./health_callout/content_with_inspect_cta");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/slo_health_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloHealthCallout({
  slo
}) {
  const {
    isLoading,
    isError,
    data
  } = (0, _use_fetch_slo_health.useFetchSloHealth)({
    list: [slo]
  });
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const handleReset = () => {
    triggerAction({
      type: 'reset',
      item: slo
    });
  };
  const managementLocator = locators.get(_constants.MANAGEMENT_APP_LOCATOR);
  const getUrl = transformId => {
    return (managementLocator === null || managementLocator === void 0 ? void 0 : managementLocator.getRedirectUrl({
      sectionId: 'data',
      appId: `transform?_a=${_rison.default.encode({
        transform: {
          queryText: transformId
        }
      })}`
    })) || '';
  };
  const rollupTransformId = (0, _react.useMemo)(() => (0, _constants2.getSLOTransformId)(slo.id, slo.revision), [slo.id, slo.revision]);
  const summaryTransformId = (0, _react.useMemo)(() => (0, _constants2.getSLOSummaryTransformId)(slo.id, slo.revision), [slo.id, slo.revision]);
  const rollupUrl = getUrl(rollupTransformId);
  const summaryUrl = getUrl(summaryTransformId);
  if (isLoading || isError || data === undefined || (data === null || data === void 0 ? void 0 : data.length) !== 1) {
    return null;
  }
  const health = data[0].health;
  if (health.overall === 'healthy') {
    return null;
  }
  const unhealthyRollup = health.rollup === 'unhealthy';
  const unhealthySummary = health.summary === 'unhealthy';
  const missingRollup = health.rollup === 'missing';
  const missingSummary = health.summary === 'missing';
  const unhealthyRollupContent = `${rollupTransformId} (unhealthy)`;
  const unhealthySummaryContent = `${summaryTransformId} (unhealthy)`;
  const missingRollupContent = `${rollupTransformId} (missing)`;
  const missingSummaryContent = `${summaryTransformId} (missing)`;
  const count = [unhealthyRollup, unhealthySummary, missingRollup, missingSummary].filter(Boolean).length;
  const stateText = (0, _slo_health_helpers.getSloHealthStateText)(unhealthyRollup || unhealthySummary, missingRollup || missingSummary);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.title', {
      defaultMessage: 'This SLO has issues with its transforms'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.healthCallout.description",
    defaultMessage: "The following {count, plural, one {transform is} other {transforms are}} in {stateText} state. You can inspect {count, plural, it {one} other {each one}} here:",
    values: {
      count,
      stateText
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, health.rollup === 'unhealthy' && !!rollupUrl && /*#__PURE__*/_react.default.createElement("li", {
    key: `${slo.id}-rollup-unhealthy`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_content_with_inspect_cta.ContentWithInspectCta, {
    textSize: "s",
    content: unhealthyRollupContent,
    url: rollupUrl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  })), health.summary === 'unhealthy' && !!summaryUrl && /*#__PURE__*/_react.default.createElement("li", {
    key: `${slo.id}-summary-unhealthy`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_content_with_inspect_cta.ContentWithInspectCta, {
    textSize: "s",
    content: unhealthySummaryContent,
    url: summaryUrl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  })), health.rollup === 'missing' && /*#__PURE__*/_react.default.createElement("li", {
    key: `${slo.id}-rollup-missing`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_content_with_reset_cta.ContentWithResetCta, {
    textSize: "s",
    content: missingRollupContent,
    handleReset: handleReset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  })), health.summary === 'missing' && /*#__PURE__*/_react.default.createElement("li", {
    key: `${slo.id}-summary-missing`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_content_with_reset_cta.ContentWithResetCta, {
    textSize: "s",
    content: missingSummaryContent,
    handleReset: handleReset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }))))));
}