"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsHistoryLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/observability-plugin/common");
var _common2 = require("@kbn/slo-schema/src/schema/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SloDetailsHistoryLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.sloDetailsHistoryLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      id,
      instanceId,
      encodedAppState
    }) => {
      const qs = new URLSearchParams();
      if (!!instanceId && instanceId !== _common2.ALL_VALUE) qs.append('instanceId', instanceId);
      if (!!encodedAppState) qs.append('_a', encodedAppState);
      return {
        app: 'slo',
        path: `/${encodeURIComponent(id)}/history${formatQueryParams(qs)}`,
        state: {}
      };
    });
  }
}
exports.SloDetailsHistoryLocatorDefinition = SloDetailsHistoryLocatorDefinition;
function formatQueryParams(qs) {
  if (qs.size === 0) {
    return '';
  }
  return `?${qs.toString()}`;
}