"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePermissions = usePermissions;
var _common = require("@kbn/observability-plugin/common");
var _use_kibana = require("./use_kibana");
var _use_fetch_global_diagnosis = require("./use_fetch_global_diagnosis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePermissions() {
  var _capabilities$sloFeat, _capabilities$sloFeat2, _globalDiagnosis$user, _globalDiagnosis$user2;
  const {
    application: {
      capabilities
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: globalDiagnosis,
    isLoading
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const hasRequiredReadCapabilities = (_capabilities$sloFeat = !!capabilities[_common.sloFeatureId].read) !== null && _capabilities$sloFeat !== void 0 ? _capabilities$sloFeat : false;
  const hasRequiredWriteCapabilities = (_capabilities$sloFeat2 = !!capabilities[_common.sloFeatureId].write) !== null && _capabilities$sloFeat2 !== void 0 ? _capabilities$sloFeat2 : false;
  const hasRequiredReadPrivileges = (_globalDiagnosis$user = !!(globalDiagnosis !== null && globalDiagnosis !== void 0 && globalDiagnosis.userPrivileges.read.has_all_requested)) !== null && _globalDiagnosis$user !== void 0 ? _globalDiagnosis$user : false;
  const hasRequiredWritePrivileges = (_globalDiagnosis$user2 = !!(globalDiagnosis !== null && globalDiagnosis !== void 0 && globalDiagnosis.userPrivileges.write.has_all_requested)) !== null && _globalDiagnosis$user2 !== void 0 ? _globalDiagnosis$user2 : false;
  return {
    isLoading,
    data: isLoading ? undefined : {
      capabilities: {
        read: hasRequiredReadCapabilities,
        write: hasRequiredWriteCapabilities
      },
      privileges: {
        read: hasRequiredReadPrivileges,
        write: hasRequiredWritePrivileges
      },
      hasAllReadRequested: hasRequiredReadCapabilities && hasRequiredReadPrivileges,
      hasAllWriteRequested: hasRequiredWriteCapabilities && hasRequiredWritePrivileges
    }
  };
}