"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSearchPlugin = void 0;
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _doc_links = require("../common/doc_links");
var _get_error_message = require("./utils/get_error_message");
var _navigation_tree = require("./navigation_tree");
var _constants = require("./application/constants");
var _i18n_string = require("../common/i18n_string");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ServerlessSearchPlugin {
  setup(core, setupDeps) {
    const queryClient = new _reactQuery.QueryClient({
      mutationCache: new _reactQuery.MutationCache({
        onError: error => {
          core.notifications.toasts.addError(error, {
            title: error.name,
            toastMessage: (0, _get_error_message.getErrorMessage)(error),
            toastLifeTimeMs: 1000
          });
        }
      }),
      queryCache: new _reactQuery.QueryCache({
        onError: error => {
          // 404s are often functionally okay and shouldn't show toasts by default
          if ((0, _get_error_message.getErrorCode)(error) === 404) {
            return;
          }
          if ((0, _get_error_message.isKibanaServerError)(error) && !error.skipToast) {
            core.notifications.toasts.addError(error, {
              title: error.name,
              toastMessage: (0, _get_error_message.getErrorMessage)(error),
              toastLifeTimeMs: 1000
            });
          }
        }
      })
    });
    const homeTitle = _i18n.i18n.translate('xpack.serverlessSearch.app.home.title', {
      defaultMessage: 'Home'
    });
    core.application.register({
      id: 'serverlessHomeRedirect',
      title: homeTitle,
      appRoute: '/app/elasticsearch',
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      visibleIn: [],
      async mount({}) {
        const [coreStart] = await core.getStartServices();
        coreStart.chrome.docTitle.change(homeTitle);
        coreStart.application.navigateToApp('searchHomepage');
        return () => {};
      }
    });
    const connectorsTitle = _i18n.i18n.translate('xpack.serverlessSearch.app.connectors.title', {
      defaultMessage: 'Connectors'
    });
    core.application.register({
      id: 'serverlessConnectors',
      title: connectorsTitle,
      appRoute: '/app/connectors',
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      visibleIn: ['globalSearch'],
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/connectors')));
        const [coreStart, services] = await core.getStartServices();
        coreStart.chrome.docTitle.change(connectorsTitle);
        _doc_links.docLinks.setDocLinks(coreStart.docLinks.links);
        return await renderApp(element, coreStart, {
          history,
          ...services
        }, queryClient);
      }
    });
    core.application.register({
      id: 'serverlessWebCrawlers',
      title: _i18n_string.WEB_CRAWLERS_LABEL,
      appRoute: '/app/web_crawlers',
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      visibleIn: ['globalSearch'],
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/web_crawlers')));
        const [coreStart, services] = await core.getStartServices();
        coreStart.chrome.docTitle.change(_i18n_string.WEB_CRAWLERS_LABEL);
        _doc_links.docLinks.setDocLinks(coreStart.docLinks.links);
        return await renderApp(element, coreStart, {
          history,
          ...services
        }, queryClient);
      }
    });
    return {};
  }
  start(core, services) {
    var _core$application$cap;
    const {
      serverless,
      management,
      security
    } = services;
    serverless.setProjectHome(_constants.SEARCH_HOMEPAGE_PATH);
    const aiAssistantIsEnabled = (_core$application$cap = core.application.capabilities.observabilityAIAssistant) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show;
    const navigationTree$ = (0, _rxjs.of)((0, _navigation_tree.navigationTree)(core.application));
    serverless.initNavigation('es', navigationTree$, {
      dataTestSubj: 'svlSearchSideNav'
    });
    const extendCardNavDefinitions = serverless.getNavigationCards(security.authz.isRoleManagementEnabled(), aiAssistantIsEnabled ? {
      observabilityAiAssistantManagement: {
        category: _managementCardsNavigation.appCategories.OTHER,
        title: _i18n.i18n.translate('xpack.serverlessSearch.aiAssistantManagementTitle', {
          defaultMessage: 'AI Assistant'
        }),
        description: _i18n.i18n.translate('xpack.serverlessSearch.aiAssistantManagementDescription', {
          defaultMessage: 'Manage knowledge base and control assistant behavior, including response language.'
        }),
        icon: 'sparkles'
      }
    } : undefined);
    management.setupCardsNavigation({
      enabled: true,
      hideLinksTo: [_managementCardsNavigation.appIds.MAINTENANCE_WINDOWS],
      extendCardNavDefinitions
    });
    return {};
  }
  stop() {}
}
exports.ServerlessSearchPlugin = ServerlessSearchPlugin;