"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilters = void 0;
var _get_general_filters = require("../get_general_filters");
var _get_saved_object_types = require("../get_saved_object_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilters = ({
  filters,
  namespaceTypes,
  hideLists
}) => {
  const namespaces = (0, _get_saved_object_types.getSavedObjectTypes)({
    namespaceType: namespaceTypes
  });
  const generalFilters = (0, _get_general_filters.getGeneralFilters)(filters, namespaces);
  const hideListsFilters = hideLists.map(listId => {
    const filtersByNamespace = namespaces.map(namespace => {
      return `not ${namespace}.attributes.list_id: ${listId}*`;
    });
    return `(${filtersByNamespace.join(' AND ')})`;
  });
  return [generalFilters, ...hideListsFilters].filter(filter => filter.trim() !== '').join(' AND ');
};
exports.getFilters = getFilters;