"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadExceptionListSummaryResponse = exports.ReadExceptionListSummaryRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _exception_list_common = require("../model/exception_list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Read exception list summary API endpoint
 *   version: 2023-10-31
 */

const ReadExceptionListSummaryRequestQuery = exports.ReadExceptionListSummaryRequestQuery = _zod.z.object({
  /**
   * Exception list's identifier generated upon creation.
   */
  id: _exception_list_common.ExceptionListId.optional(),
  /**
   * Exception list's human readable identifier.
   */
  list_id: _exception_list_common.ExceptionListHumanId.optional(),
  namespace_type: _exception_list_common.ExceptionNamespaceType.optional().default('single'),
  /**
   * Search filter clause
   */
  filter: _zod.z.string().optional()
});
const ReadExceptionListSummaryResponse = exports.ReadExceptionListSummaryResponse = _zod.z.object({
  windows: _zod.z.number().int().min(0).optional(),
  linux: _zod.z.number().int().min(0).optional(),
  macos: _zod.z.number().int().min(0).optional(),
  total: _zod.z.number().int().min(0).optional()
});