"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ai4SocMeteringService = exports.Ai4SocMeteringService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _product = require("../../../common/product");
var _metering = require("../constants/metering");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Ai4SocMeteringService {
  constructor() {
    // only run metering if ai4soc add-on is enabled
    (0, _defineProperty2.default)(this, "shouldMeter", config => {
      return !!this.getAiSocProduct(config);
    });
    (0, _defineProperty2.default)(this, "getUsageRecords", async ({
      taskId,
      cloudSetup,
      config,
      logger
    }) => {
      var _cloudSetup$serverles;
      const product = this.getAiSocProduct(config);
      if (!product) {
        return {
          records: []
        };
      }
      const projectId = cloudSetup === null || cloudSetup === void 0 ? void 0 : (_cloudSetup$serverles = cloudSetup.serverless) === null || _cloudSetup$serverles === void 0 ? void 0 : _cloudSetup$serverles.projectId;
      const timestamp = new Date();
      if (!projectId) {
        logger.error(`ai4soc metering failed due to missing project id. taskId ${taskId} at ${timestamp.toISOString()}`);
        return {
          records: []
        };
      }
      const record = this.buildMeteringRecord({
        timestampStr: timestamp.toISOString(),
        taskId,
        projectId,
        product
      });
      return {
        latestTimestamp: timestamp,
        records: [record],
        shouldRunAgain: false
      };
    });
  }
  buildMeteringRecord({
    timestampStr,
    taskId,
    projectId,
    product
  }) {
    // truncate to hour
    const timestamp = new Date(timestampStr);
    timestamp.setMinutes(0);
    timestamp.setSeconds(0);
    timestamp.setMilliseconds(0);
    const usageRecord = {
      // unique by project + hour
      id: `ai4soc-${projectId}-${timestamp.toISOString()}`,
      usage_timestamp: timestampStr,
      creation_timestamp: timestampStr,
      usage: {
        type: _metering.METERING_TASK.USAGE_TYPE,
        period_seconds: _metering.METERING_TASK.SAMPLE_PERIOD_SECONDS,
        quantity: 1
      },
      source: {
        id: taskId,
        instance_group_id: projectId,
        metadata: {
          tier: product.product_tier
        }
      }
    };
    return usageRecord;
  }
  getAiSocProduct(config) {
    return config.productTypes.find(productType => {
      return productType.product_line === _product.ProductLine.aiSoc;
    });
  }
}
exports.Ai4SocMeteringService = Ai4SocMeteringService;
const ai4SocMeteringService = exports.ai4SocMeteringService = new Ai4SocMeteringService();