"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsRoutes = void 0;
var _create = require("./create");
var _update = require("./rules/update");
var _get = require("./get");
var _start = require("./start");
var _stats = require("./stats");
var _translation_stats = require("./translation_stats");
var _stop = require("./stop");
var _stats_all = require("./stats_all");
var _upsert = require("./resources/upsert");
var _get2 = require("./resources/get");
var _install = require("./install");
var _missing = require("./resources/missing");
var _get_prebuilt_rules = require("./get_prebuilt_rules");
var _get_integrations = require("./get_integrations");
var _get_missing_privileges = require("./privileges/get_missing_privileges");
var _evaluate = require("./evaluation/evaluate");
var _create2 = require("./rules/create");
var _get3 = require("./rules/get");
var _delete = require("./delete");
var _integrations_stats = require("./integrations_stats");
var _update2 = require("./update");
var _update_index_pattern = require("./update_index_pattern");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsRoutes = (router, config, logger) => {
  /** Rules Migrations */
  (0, _create.registerSiemRuleMigrationsCreateRoute)(router, logger);
  (0, _get.registerSiemRuleMigrationsGetRoute)(router, logger);
  (0, _delete.registerSiemRuleMigrationsDeleteRoute)(router, logger);
  (0, _update2.registerSiemRuleMigrationsUpdateRoute)(router, logger);
  /** *******/

  /** Rules */
  (0, _create2.registerSiemRuleMigrationsCreateRulesRoute)(router, logger);
  (0, _get3.registerSiemRuleMigrationsGetRulesRoute)(router, logger);
  (0, _update.registerSiemRuleMigrationsUpdateRulesRoute)(router, logger);
  /** *******/

  /** Tasks **/
  (0, _stats_all.registerSiemRuleMigrationsStatsAllRoute)(router, logger);
  (0, _get_prebuilt_rules.registerSiemRuleMigrationsPrebuiltRulesRoute)(router, logger);
  (0, _start.registerSiemRuleMigrationsStartRoute)(router, logger);
  (0, _stats.registerSiemRuleMigrationsStatsRoute)(router, logger);
  (0, _translation_stats.registerSiemRuleMigrationsTranslationStatsRoute)(router, logger);
  (0, _stop.registerSiemRuleMigrationsStopRoute)(router, logger);
  (0, _update_index_pattern.registerSiemRuleMigrationsUpdateIndexPatternRoute)(router, logger);
  /** *******/

  /** Install */
  (0, _install.registerSiemRuleMigrationsInstallRoute)(router, logger);
  /** *******/

  /** Integrations */
  (0, _get_integrations.registerSiemRuleMigrationsIntegrationsRoute)(router, logger);
  (0, _integrations_stats.registerSiemRuleMigrationsIntegrationsStatsRoute)(router, logger);
  /** *******/

  /** Resources */
  (0, _upsert.registerSiemRuleMigrationsResourceUpsertRoute)(router, logger);
  (0, _get2.registerSiemRuleMigrationsResourceGetRoute)(router, logger);
  (0, _missing.registerSiemRuleMigrationsResourceGetMissingRoute)(router, logger);
  /** *******/

  (0, _get_missing_privileges.registerSiemRuleMigrationsGetMissingPrivilegesRoute)(router, logger);
  if (config.experimentalFeatures.assistantModelEvaluation) {
    // Use the same experimental feature flag as the assistant model evaluation.
    // This route is not intended to be used by the end user, but rather for internal purposes.
    (0, _evaluate.registerSiemRuleMigrationsEvaluateRoute)(router, logger);
  }
};
exports.registerSiemRuleMigrationsRoutes = registerSiemRuleMigrationsRoutes;