"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationsTaskService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dashboard_migrations_task_client = require("./dashboard_migrations_task_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardMigrationsTaskService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "migrationsRunning", void 0);
    this.logger = logger;
    this.migrationsRunning = new Map();
  }
  createClient({
    request,
    currentUser,
    dataClient,
    dependencies
  }) {
    return new _dashboard_migrations_task_client.DashboardMigrationsTaskClient(this.migrationsRunning, this.logger, dataClient, request, currentUser, dependencies);
  }

  /** Stops all running migrations */
  stopAll() {
    this.migrationsRunning.forEach(migrationRunning => {
      migrationRunning.abortController.abort('Server shutdown');
    });
    this.migrationsRunning.clear();
  }
}
exports.DashboardMigrationsTaskService = DashboardMigrationsTaskService;