"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFixQueryErrorsNode = void 0;
var _fix_esql_query_errors = require("../../../../../../../common/task/agent/helpers/fix_esql_query_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFixQueryErrorsNode = params => {
  const fixEsqlQueryErrors = (0, _fix_esql_query_errors.getFixEsqlQueryErrors)(params);
  return async state => {
    const {
      query
    } = await fixEsqlQueryErrors({
      invalidQuery: state.esql_query,
      validationErrors: state.validation_errors.esql_errors
    });
    if (!query) {
      return {};
    }
    return {
      esql_query: query
    };
  };
};
exports.getFixQueryErrorsNode = getFixQueryErrorsNode;