"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsMappingNode = void 0;
var _convert_esql_schema_cim_to_ecs = require("../../../../../../../common/task/agent/helpers/convert_esql_schema_cim_to_ecs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEcsMappingNode = params => {
  const convertEsqlSchemaCimToEcs = (0, _convert_esql_schema_cim_to_ecs.getConvertEsqlSchemaCisToEcs)(params);
  return async state => {
    var _state$parsed_panel$t, _state$description, _state$esql_query, _state$inline_query;
    const {
      query,
      comments
    } = await convertEsqlSchemaCimToEcs({
      title: (_state$parsed_panel$t = state.parsed_panel.title) !== null && _state$parsed_panel$t !== void 0 ? _state$parsed_panel$t : '',
      description: (_state$description = state.description) !== null && _state$description !== void 0 ? _state$description : '',
      query: (_state$esql_query = state.esql_query) !== null && _state$esql_query !== void 0 ? _state$esql_query : '',
      originalQuery: (_state$inline_query = state.inline_query) !== null && _state$inline_query !== void 0 ? _state$inline_query : ''
    });

    // Set includes_ecs_mapping to indicate that this node has been executed to ensure it only runs once
    return {
      includes_ecs_mapping: true,
      comments,
      ...(query && {
        esql_query: query
      })
    };
  };
};
exports.getEcsMappingNode = getEcsMappingNode;